/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldVanDerGrintenI
extends MapProjection {
    private static final long serialVersionUID = -4432651736803211463L;
    private static final double TOL = 1.0E-10;
    private static final double THIRD = 0.3333333333333333;
    private static final double TWO_THRD = 0.6666666666666666;
    private static final double C2_27 = 0.07407407407407407;
    private static final double PI4_3 = 4.188790204786391;
    private static final double PISQ = Math.PI * Math.PI;
    private static final double TPISQ = 19.739208802178716;
    private static final double HPISQ = 4.934802200544679;

    public WorldVanDerGrintenI(ParameterValueGroup values) throws ParameterNotFoundException {
        super(values);
    }

    public WorldVanDerGrintenI(ParameterValueGroup values, Collection<GeneralParameterDescriptor> expected) throws ParameterNotFoundException {
        super(values, expected);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        double y;
        double x;
        double p2 = Math.abs(phi / 1.5707963267948966);
        if (p2 - 1.0E-10 > 1.0) {
            throw new ProjectionException();
        }
        if (p2 > 1.0) {
            p2 = 1.0;
        }
        if (Math.abs(phi) <= 1.0E-10) {
            x = lambda;
            y = 0.0;
        } else if (Math.abs(lambda) <= 1.0E-10 || Math.abs(p2 - 1.0) < 1.0E-10) {
            x = 0.0;
            y = Math.PI * Math.tan(0.5 * Math.asin(p2));
            if (phi < 0.0) {
                y = -y;
            }
        } else {
            double al = 0.5 * Math.abs(Math.PI / lambda - lambda / Math.PI);
            double al2 = al * al;
            double g = Math.sqrt(1.0 - p2 * p2);
            g /= p2 + g - 1.0;
            double g2 = g * g;
            p2 = g * (2.0 / p2 - 1.0);
            p2 *= p2;
            x = g - p2;
            g = p2 + al2;
            x = Math.PI * (al * x + Math.sqrt(al2 * x * x - g * (g2 - p2))) / g;
            if (lambda < 0.0) {
                x = -x;
            }
            y = Math.abs(x / Math.PI);
            if ((y = 1.0 - y * (y + 2.0 * al)) < -1.0E-10) {
                throw new ProjectionException();
            }
            y = y < 0.0 ? 0.0 : Math.sqrt(y) * (phi < 0.0 ? -Math.PI : Math.PI);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double d;
        double d2;
        double x2 = x * x;
        double ay = Math.abs(y);
        if (d2 < 1.0E-10) {
            double lambda;
            double phi2 = 0.0;
            double t = x2 * x2 + 19.739208802178716 * (x2 + 4.934802200544679);
            double d3 = lambda = Math.abs(x) <= 1.0E-10 ? 0.0 : 0.5 * (x2 - Math.PI * Math.PI + Math.sqrt(t)) / x;
            if (ptDst != null) {
                ptDst.setLocation(lambda, phi2);
                return ptDst;
            }
            return new Point2D.Double(lambda, phi2);
        }
        double y2 = y * y;
        double r = x2 + y2;
        double r2 = r * r;
        double c1 = -Math.PI * ay * (r + Math.PI * Math.PI);
        double c3 = r2 + Math.PI * 2 * (ay * r + Math.PI * (y2 + Math.PI * (ay + 1.5707963267948966)));
        double c2 = c1 + Math.PI * Math.PI * (r - 3.0 * y2);
        double c0 = Math.PI * ay;
        double al = c1 / c3 - 0.3333333333333333 * (c2 /= c3) * c2;
        double m = 2.0 * Math.sqrt(-0.3333333333333333 * al);
        double d4 = 0.07407407407407407 * c2 * c2 * c2 + (c0 * c0 - 0.3333333333333333 * c2 * c1) / c3;
        d4 = 3.0 * d4 / (al * m);
        double t = Math.abs(d4);
        if (d - 1.0E-10 <= 1.0) {
            d4 = t > 1.0 ? (d4 > 0.0 ? 0.0 : Math.PI) : Math.acos(d4);
            phi = Math.PI * (m * Math.cos(d4 * 0.3333333333333333 + 4.188790204786391) - 0.3333333333333333 * c2);
            if (y < 0.0) {
                phi = -phi;
            }
        } else {
            throw new ProjectionException();
        }
        t = r2 + 19.739208802178716 * (x2 - y2 + 4.934802200544679);
        double lambda = Math.abs(x) <= 1.0E-10 ? 0.0 : 0.5 * (r - Math.PI * Math.PI + (t <= 0.0 ? 0.0 : Math.sqrt(t))) / x;
        if (ptDst != null) {
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
        return new Point2D.Double(lambda, phi);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -4432651736803211463L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "World_Van_der_Grinten_I"), new NamedIdentifier(Citations.GEOTOOLS, "World_Van_der_Grinten_I"), new NamedIdentifier(Citations.ESRI, "World_Van_der_Grinten_I"), new NamedIdentifier(Citations.GEOTIFF, "World_Van_der_Grinten_I"), new NamedIdentifier(Citations.OGC, "Van_der_Grinten_I"), new NamedIdentifier(Citations.GEOTOOLS, "Van_der_Grinten_I"), new NamedIdentifier(Citations.GEOTIFF, "Van_der_Grinten_I"), new NamedIdentifier(Citations.ESRI, "Van_der_Grinten_I"), new NamedIdentifier(Citations.OGC, "CT_VanDerGrinten"), new NamedIdentifier(Citations.GEOTOOLS, "CT_VanDerGrinten"), new NamedIdentifier(Citations.GEOTIFF, "CT_VanDerGrinten"), new NamedIdentifier(Citations.ESRI, "CT_VanDerGrinten"), new NamedIdentifier(Citations.EPSG, "54029"), new NamedIdentifier(Citations.ESRI, "54029"), new NamedIdentifier(Citations.OGC, "Van der Grinten WGS84"), new NamedIdentifier(Citations.GEOTOOLS, "Van der Grinten WGS84"), new NamedIdentifier(Citations.GEOTIFF, "Van der Grinten WGS84"), new NamedIdentifier(Citations.ESRI, "Van der Grinten WGS84"), new NamedIdentifier(Citations.EPSG, "Van der Grinten WGS84"), new NamedIdentifier(Citations.OGC, "Van der Grinten"), new NamedIdentifier(Citations.GEOTOOLS, "Van der Grinten"), new NamedIdentifier(Citations.GEOTIFF, "Van der Grinten"), new NamedIdentifier(Citations.ESRI, "Van der Grinten"), new NamedIdentifier(Citations.EPSG, "Van der Grinten")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new WorldVanDerGrintenI(parameters);
        }
    }
}

