/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.util.logging.Level;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.EquatorialOrthographic;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ObliqueOrthographic;
import org.geotools.referencing.operation.projection.PolarOrthographic;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PlanarProjection;

public abstract class Orthographic
extends MapProjection {
    private static final long serialVersionUID = -6489939032996419868L;
    private static final double EPSILON = 1.0E-6;

    protected Orthographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3180410512573499562L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Orthographic"), new NamedIdentifier(Citations.GEOTIFF, "CT_Orthographic"), new NamedIdentifier(Citations.ESRI, "Orthographic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(160))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<PlanarProjection> getOperationType() {
            return PlanarProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            double latitudeOfOrigin = Math.abs(MapProjection.AbstractProvider.doubleValue(LATITUDE_OF_ORIGIN, parameters));
            if (!Provider.isSpherical(parameters)) {
                MapProjection.LOGGER.log(Level.FINE, "GeoTools Orthographic is defined only on the sphere, we're going to use spherical equations even if the projection is using an ellipsoid");
            }
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                return new PolarOrthographic(parameters);
            }
            if (latitudeOfOrigin < 1.0E-6) {
                return new EquatorialOrthographic(parameters);
            }
            return new ObliqueOrthographic(parameters);
        }
    }
}

