/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.operation.builder.Circle;
import org.geotools.referencing.operation.builder.Polygon;
import org.geotools.referencing.operation.builder.TriangulationException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TINTriangle
extends Polygon {
    public DirectPosition p0;
    public DirectPosition p1;
    public DirectPosition p2;
    private final List<TINTriangle> adjacentTriangles = new ArrayList<TINTriangle>();

    protected TINTriangle(DirectPosition p0, DirectPosition p1, DirectPosition p2) {
        super(new DirectPosition[]{p0, p1, p2, p0});
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    protected Circle getCircumCicle() {
        List<DirectPosition> reducedVertices = this.reduce();
        CoordinateReferenceSystem crs = reducedVertices.get(1).getCoordinateReferenceSystem();
        double x1 = reducedVertices.get(1).getCoordinates()[0];
        double y1 = reducedVertices.get(1).getCoordinates()[1];
        double x2 = reducedVertices.get(2).getCoordinates()[0];
        double y2 = reducedVertices.get(2).getCoordinates()[1];
        double t = 0.5 * (x1 * x1 + y1 * y1 - x1 * x2 - y1 * y2) / (y1 * x2 - x1 * y2);
        DirectPosition2D center = new DirectPosition2D(crs, x2 / 2.0 - t * y2 + this.p0.getCoordinates()[0], y2 / 2.0 + t * x2 + this.p0.getCoordinates()[1]);
        return new Circle(center.getPosition(), center.distance(new DirectPosition2D(this.p0)));
    }

    public List<TINTriangle> subTriangles(DirectPosition newVertex) {
        ArrayList<TINTriangle> triangles = new ArrayList<TINTriangle>();
        TINTriangle trigA = new TINTriangle(this.p0, this.p1, newVertex);
        TINTriangle trigB = new TINTriangle(this.p1, this.p2, newVertex);
        TINTriangle trigC = new TINTriangle(this.p2, this.p0, newVertex);
        try {
            trigA.addAdjacentTriangle(trigB);
            trigA.addAdjacentTriangle(trigC);
            trigB.addAdjacentTriangle(trigA);
            trigB.addAdjacentTriangle(trigC);
            trigC.addAdjacentTriangle(trigA);
            trigC.addAdjacentTriangle(trigB);
        }
        catch (TriangulationException e) {
            // empty catch block
        }
        trigA.tryToAddAdjacent(this.getAdjacentTriangles());
        trigB.tryToAddAdjacent(this.getAdjacentTriangles());
        trigC.tryToAddAdjacent(this.getAdjacentTriangles());
        triangles.add(trigA);
        triangles.add(trigB);
        triangles.add(trigC);
        for (TINTriangle trig : this.getAdjacentTriangles()) {
            trig.removeAdjacent(this);
        }
        return triangles;
    }

    protected int tryToAddAdjacent(List<TINTriangle> adjacents) {
        Iterator<TINTriangle> i = adjacents.iterator();
        int count = 0;
        while (i.hasNext()) {
            try {
                TINTriangle candidate = i.next();
                if (candidate.isAdjacent(this) && !this.adjacentTriangles.contains(candidate)) {
                    this.addAdjacentTriangle(candidate);
                }
                if (!candidate.isAdjacent(this) || candidate.adjacentTriangles.contains(this)) continue;
                candidate.addAdjacentTriangle(this);
                ++count;
            }
            catch (TriangulationException e) {}
        }
        return count;
    }

    protected boolean addAdjacentTriangle(TINTriangle adjacent) throws TriangulationException {
        if (this.isAdjacent(adjacent)) {
            this.adjacentTriangles.add(adjacent);
            return true;
        }
        return false;
    }

    private boolean isAdjacent(TINTriangle adjacent) throws TriangulationException {
        int identicalVertices = 0;
        if (adjacent.hasVertex(this.p0)) {
            ++identicalVertices;
        }
        if (adjacent.hasVertex(this.p1)) {
            ++identicalVertices;
        }
        if (adjacent.hasVertex(this.p2)) {
            ++identicalVertices;
        }
        if (identicalVertices == 3) {
            throw new TriangulationException("Same triangle");
        }
        return identicalVertices == 2;
    }

    public List<TINTriangle> getAdjacentTriangles() {
        return this.adjacentTriangles;
    }

    protected void removeAdjacent(TINTriangle remAdjacent) {
        this.adjacentTriangles.remove(remAdjacent);
    }
}

