/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AbstractEpsgMediator;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.OrderedAxisAuthorityFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class LongitudeFirstEpsgDecorator
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
CoordinateOperationAuthorityFactory,
DatumAuthorityFactory {
    public LongitudeFirstEpsgDecorator() {
        this((Hints)null);
    }

    public LongitudeFirstEpsgDecorator(Hints userHints) {
        super(userHints, 40 + LongitudeFirstEpsgDecorator.relativePriority(userHints));
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
    }

    private void put(Hints userHints, Hints.Key key) {
        Object value = null;
        if (userHints != null) {
            value = userHints.get(key);
        }
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.hints.put(key, value);
    }

    private static int relativePriority(Hints userHints) {
        try {
            if (Boolean.getBoolean("org.geotools.referencing.forceXY")) {
                return 10;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return -10;
    }

    public Citation getAuthority() {
        return Citations.EPSG;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        Hints backingStoreHints = new Hints(Hints.CRS_AUTHORITY_FACTORY, AbstractEpsgMediator.class);
        backingStoreHints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        backingStoreHints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        backingStoreHints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        try {
            factory = (AbstractAuthorityFactory)((Object)ReferencingFactoryFinder.getCRSAuthorityFactory("EPSG", backingStoreHints));
        }
        catch (org.geotools.factory.FactoryNotFoundException exception) {
            throw new FactoryNotFoundException(exception);
        }
        catch (FactoryRegistryException exception) {
            throw new FactoryException(exception);
        }
        return new OrderedAxisAuthorityFactory(factory, new Hints(this.hints), null);
    }
}

