/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;
    public static final DefaultTimeCS DAYS;
    public static final DefaultTimeCS SECONDS;
    public static final DefaultTimeCS MILLISECONDS;

    public DefaultTimeCS(TimeCS cs) {
        super(cs);
    }

    public DefaultTimeCS(String name, CoordinateSystemAxis axis) {
        super(name, new CoordinateSystemAxis[]{axis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    public DefaultTimeCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, new CoordinateSystemAxis[]{axis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.FUTURE.equals(direction.absolute());
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection direction, Unit<?> unit) {
        return SI.SECOND.isCompatible(unit);
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        return new Measure(Math.abs(coord1[0] - coord2[0]), this.getDistanceUnit());
    }

    static {
        Map<String, Object> properties = DefaultTimeCS.name(214);
        DefaultCoordinateSystemAxis axis = DefaultCoordinateSystemAxis.TIME;
        DAYS = new DefaultTimeCS(properties, (CoordinateSystemAxis)axis);
        InternationalString name = axis.getAlias().iterator().next().toInternationalString();
        axis = new DefaultCoordinateSystemAxis(name, "t", AxisDirection.FUTURE, SI.SECOND);
        SECONDS = new DefaultTimeCS(properties, (CoordinateSystemAxis)axis);
        axis = new DefaultCoordinateSystemAxis(name, "t", AxisDirection.FUTURE, SI.MILLI(SI.SECOND));
        MILLISECONDS = new DefaultTimeCS(properties, (CoordinateSystemAxis)axis);
    }
}

