/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGeographicCRS
extends AbstractSingleCRS
implements GeographicCRS {
    private static final long serialVersionUID = 861224913438092335L;
    public static final DefaultGeographicCRS WGS84;
    public static final DefaultGeographicCRS WGS84_3D;

    public DefaultGeographicCRS(GeographicCRS crs) {
        super(crs);
    }

    public DefaultGeographicCRS(GeodeticDatum datum, EllipsoidalCS cs) {
        this(DefaultGeographicCRS.getProperties(datum), datum, cs);
    }

    public DefaultGeographicCRS(String name, GeodeticDatum datum, EllipsoidalCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, EllipsoidalCS cs) {
        super(properties, datum, cs);
    }

    @Override
    public EllipsoidalCS getCoordinateSystem() {
        return (EllipsoidalCS)super.getCoordinateSystem();
    }

    @Override
    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (!(this.coordinateSystem instanceof DefaultEllipsoidalCS)) {
            throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
        }
        Ellipsoid ellipsoid = ((GeodeticDatum)this.datum).getEllipsoid();
        if (!(ellipsoid instanceof DefaultEllipsoid)) {
            throw new UnsupportedImplementationException(ellipsoid.getClass());
        }
        DefaultEllipsoidalCS cs = (DefaultEllipsoidalCS)this.coordinateSystem;
        DefaultEllipsoid e = (DefaultEllipsoid)ellipsoid;
        if (coord1.length != 2 || coord2.length != 2 || cs.getDimension() != 2) {
            return super.distance(coord1, coord2);
        }
        return new Measure(e.orthodromicDistance(cs.getLongitude(coord1), cs.getLatitude(coord1), cs.getLongitude(coord2), cs.getLatitude(coord2)), e.getAxisUnit());
    }

    @Override
    public int hashCode() {
        return 0xED31AC2F ^ super.hashCode();
    }

    static Unit<Angle> getAngularUnit(CoordinateSystem coordinateSystem) {
        Unit<Angle> unit = NonSI.DEGREE_ANGLE;
        int i = coordinateSystem.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = coordinateSystem.getAxis(i);
            Unit<?> candidate = axis.getUnit();
            if (!NonSI.DEGREE_ANGLE.isCompatible(candidate)) continue;
            unit = candidate.asType(Angle.class);
            if (!AxisDirection.EAST.equals(axis.getDirection().absolute())) continue;
            break;
        }
        return unit;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        Unit<Angle> oldUnit = formatter.getAngularUnit();
        Unit<Angle> unit = DefaultGeographicCRS.getAngularUnit(this.coordinateSystem);
        formatter.setAngularUnit(unit);
        formatter.append(this.datum);
        formatter.append(((GeodeticDatum)this.datum).getPrimeMeridian());
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append(this.coordinateSystem.getAxis(i));
        }
        if (!unit.equals(this.getUnit())) {
            formatter.setInvalidWKT(GeographicCRS.class);
        }
        formatter.setAngularUnit(oldUnit);
        return "GEOGCS";
    }

    static {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", "WGS84(DD)");
        String[] alias = new String[]{"WGS84", "WGS 84"};
        properties.put("alias", alias);
        properties.put("domainOfValidity", ExtentImpl.WORLD);
        WGS84 = new DefaultGeographicCRS(properties, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        alias[1] = "WGS 84 (geographic 3D)";
        WGS84_3D = new DefaultGeographicCRS(properties, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_3D);
    }
}

