/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection_BoundsFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter.function");
    FeatureCollection<FeatureType, Feature> previousFeatureCollection = null;
    Object bounds = null;

    public Collection_BoundsFunction() {
        super("Collection_Bounds");
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    static CalcResult calculateBounds(FeatureCollection<? extends FeatureType, ? extends Feature> collection) throws IllegalFilterException, IOException {
        BoundsVisitor boundsVisitor = new BoundsVisitor();
        collection.accepts(boundsVisitor, null);
        return boundsVisitor.getResult();
    }

    @Override
    public void setParameters(List args) {
        super.setParameters(args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("Require a single argument for unique");
        }
        Expression expr = (Expression)this.getExpression(0);
        expr.accept(new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.bounds = null;
                try {
                    CalcResult result = Collection_BoundsFunction.calculateBounds(featureCollection);
                    if (result != null) {
                        this.bounds = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.bounds;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

