/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;

public class StandardDeviationVisitor
implements FeatureCalc {
    private Expression expr;
    boolean visited = false;
    int countNull = 0;
    int countNaN = 0;
    int count = 0;
    double mean = 0.0;
    double m2 = 0.0;

    @Deprecated
    public StandardDeviationVisitor(Expression expr, double average) {
        this.expr = expr;
    }

    public StandardDeviationVisitor(Expression expr) {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    public CalcResult getResult() {
        if (this.count == 0) {
            return CalcResult.NULL_RESULT;
        }
        return new AbstractCalcResult(){

            public Object getValue() {
                if (StandardDeviationVisitor.this.count == 0) {
                    return null;
                }
                return new Double(Math.sqrt(StandardDeviationVisitor.this.m2 / (double)StandardDeviationVisitor.this.count));
            }
        };
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        double doubleVal;
        Object value = this.expr.evaluate(feature);
        if (value == null) {
            ++this.countNull;
            return;
        }
        if (value instanceof Double && (Double.isNaN(doubleVal = ((Double)value).doubleValue()) || Double.isInfinite(doubleVal))) {
            ++this.countNaN;
            return;
        }
        double x = ((Number)value).doubleValue();
        ++this.count;
        double delta = x - this.mean;
        this.mean += delta / (double)this.count;
        this.m2 += delta * (x - this.mean);
    }

    public void reset() {
        this.count = 0;
        this.countNull = 0;
        this.countNaN = 0;
        this.m2 = 0.0;
        this.mean = 0.0;
    }

    public int getNaNCount() {
        return this.countNaN;
    }

    public int getNullCount() {
        return this.countNull;
    }
}

