/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingSimpleFeatureCollection
implements SimpleFeatureCollection {
    protected SimpleFeatureCollection delegate;

    protected DecoratingSimpleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate) {
        this.delegate = DataUtilities.simple(delegate);
    }

    protected DecoratingSimpleFeatureCollection(SimpleFeatureCollection delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        SimpleFeatureIterator it = this.features();
        try {
            Exception exception = null;
            while (it.hasNext()) {
                try {
                    visitor.visit((Feature)it.next());
                }
                catch (Exception e) {
                    if (exception == null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        }
        finally {
            this.close(it);
        }
    }

    @Override
    public boolean add(SimpleFeature o) {
        return this.delegate.add(o);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(FeatureCollection c) {
        return this.delegate.addAll(c);
    }

    @Override
    public void addListener(CollectionListener listener) throws NullPointerException {
        this.delegate.addListener(listener);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> close) {
        this.delegate.close(close);
    }

    @Override
    public void close(Iterator<SimpleFeature> close) {
        this.delegate.close(close);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public SimpleFeatureIterator features() {
        return this.delegate.features();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.delegate.getBounds();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.delegate.getSchema();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void purge() {
        this.delegate.purge();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.delegate.removeListener(listener);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return this.delegate.sort(order);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        return this.delegate.subCollection(filter);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public String getID() {
        return this.delegate.getID();
    }
}

