/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.FeatureImplUtils;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexAttributeImpl
extends AttributeImpl
implements ComplexAttribute {
    public ComplexAttributeImpl(Collection<Property> properties, AttributeDescriptor descriptor, Identifier id) {
        super((Object)ComplexAttributeImpl.cloneProperties(properties), descriptor, id);
    }

    public ComplexAttributeImpl(Collection<Property> properties, ComplexType type, Identifier id) {
        this(properties, (AttributeDescriptor)new AttributeDescriptorImpl(type, type.getName(), 1, 1, true, null), id);
    }

    @Override
    public ComplexType getType() {
        return (ComplexType)super.getType();
    }

    @Override
    public Collection<? extends Property> getValue() {
        return FeatureImplUtils.unmodifiable((Collection)super.getValue());
    }

    @Override
    public Collection<Property> getProperties() {
        return FeatureImplUtils.unmodifiable((Collection)super.getValue());
    }

    protected Collection properties() {
        return (Collection)super.getValue();
    }

    @Override
    public Collection<Property> getProperties(Name name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        Iterator p = this.getValue().iterator();
        while (p.hasNext()) {
            Property property = (Property)p.next();
            if (!((Object)property.getName()).equals(name)) continue;
            matches.add(property);
        }
        return matches;
    }

    @Override
    public Collection<Property> getProperties(String name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Property property : this.properties()) {
            if (!property.getName().getLocalPart().equals(name)) continue;
            matches.add(property);
        }
        return matches;
    }

    @Override
    public Property getProperty(Name name) {
        for (Property property : this.properties()) {
            if (!((Object)property.getName()).equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public Property getProperty(String name) {
        Iterator p = this.getValue().iterator();
        while (p.hasNext()) {
            Property property = (Property)p.next();
            if (!property.getName().getLocalPart().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        this.setValue((Collection)newValue);
    }

    @Override
    public void setValue(Collection<Property> newValue) {
        super.setValue(ComplexAttributeImpl.cloneProperties(newValue));
    }

    private static Collection cloneProperties(Collection original) {
        if (original == null) {
            return null;
        }
        ArrayList clone = null;
        try {
            clone = (ArrayList)original.getClass().newInstance();
        }
        catch (Exception e) {
            clone = new ArrayList();
        }
        clone.addAll(original);
        return clone;
    }
}

