/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class FilteringFeatureIterator
implements SimpleFeatureIterator {
    protected SimpleFeatureIterator delegate;
    protected Filter filter;
    protected SimpleFeature next;

    public FilteringFeatureIterator(SimpleFeatureIterator delegate, Filter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            SimpleFeature peek = (SimpleFeature)this.delegate.next();
            if (!this.filter.evaluate(peek)) continue;
            this.next = peek;
            break;
        }
        return this.next != null;
    }

    public SimpleFeature next() throws NoSuchElementException {
        SimpleFeature f = this.next;
        this.next = null;
        return f;
    }

    public void close() {
        this.delegate.close();
        this.delegate = null;
        this.next = null;
        this.filter = null;
    }
}

