/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util.lru;

import java.io.Serializable;
import org.apache.commons.util.lru.LRUElementImp;
import org.apache.commons.util.lru.LRUStore;

public class LRUStoreImp
extends LRUStore {
    int numWaterfalled = 0;

    public LRUStoreImp() {
    }

    public LRUStoreImp(int max) {
        super(max);
    }

    public void put(Serializable key, Serializable val) {
        LRUElementImp le = new LRUElementImp(key, val);
        this.update(le);
    }

    public void waterfall(Object obj) {
        ++this.numWaterfalled;
        System.out.println(this.numWaterfalled + " -- They are killing me! [" + obj.toString() + "]");
        System.out.println("The LRUStore said that I was the least recently used item.");
        System.out.println("Put me on disk if you still want me.");
    }

    public static void main(String[] args) {
        int size = 1000;
        if (args.length > 0) {
            try {
                size = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("arg 1 (size) should be a number");
            }
        }
        int cycles = 2;
        if (args.length > 1) {
            try {
                cycles = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("arg 2 (cycles) should be a number");
            }
        }
        int over = 0;
        if (args.length > 2) {
            try {
                over = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                System.out.println("arg 3 (number to put over the size) should be a number");
            }
        }
        boolean dump = false;
        if (args.length > 3) {
            try {
                dump = Boolean.valueOf(args[3]);
            }
            catch (NumberFormatException e) {
                System.out.println("arg 3 (dump) should be a boolean");
            }
        }
        System.out.println("Size = " + size);
        System.out.println("cycles = " + cycles);
        System.out.println("over = " + over);
        LRUStoreImp map = new LRUStoreImp(size);
        boolean show = false;
        if (args.length > 2) {
            try {
                show = Boolean.valueOf(args[2]);
            }
            catch (Exception e) {
                System.out.println("arg 3 (show) should be true or false");
            }
        }
        int i = 0;
        while (i < cycles) {
            long startP = System.currentTimeMillis();
            int j = 0;
            while (j < size + over) {
                map.put((Serializable)((Object)("key" + j)), (Serializable)((Object)("value" + j)));
                ++j;
            }
            long endP = System.currentTimeMillis();
            long deltaP = endP - startP;
            System.out.println("took " + deltaP + " ms. to put " + String.valueOf(size + over));
            System.out.println("\n");
            long startG = System.currentTimeMillis();
            int j2 = 0;
            while (j2 < size + over) {
                String val = (String)((Object)map.get((Serializable)((Object)("key" + j2))));
                if (show) {
                    System.out.println(val);
                }
                ++j2;
            }
            long endG = System.currentTimeMillis();
            long deltaG = endG - startG;
            System.out.println("took " + deltaG + " ms. to get " + String.valueOf(size + over));
            System.out.println("\n");
            ++i;
        }
        System.out.println("Size = " + size);
        System.out.println("cycles = " + cycles);
        System.out.println("over = " + over);
        System.out.println("\n");
        if (dump) {
            map.dumpMap();
            System.out.println("\n");
            map.dumpEntries();
        }
    }
}

