/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util.lru;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.util.lru.ILRUElement;
import org.apache.commons.util.lru.LRUElement;
import org.apache.commons.util.lru.LRUElementDescriptor;

public class LRUStore
implements Serializable {
    private static final boolean debugcmd = false;
    private static final boolean debugR = false;
    private static final String NAME_COMPONENT_DELIMITER = ":";
    protected Map map = new Hashtable();
    private LRUElementDescriptor first;
    private LRUElementDescriptor last;
    private int max = 1000;
    private int chunkSize = 1;

    public LRUStore() {
    }

    public LRUStore(int max) {
        this.initialize(max);
    }

    public void initialize(int max) {
        this.max = max;
    }

    public void update(ILRUElement ce) {
        int size;
        this.addFirst(ce);
        LRUElementDescriptor old = this.map.put(ce.getKey(), this.first);
        if (this.first.equals(old)) {
            this.removeNode(old);
        }
        if ((size = this.map.size()) <= this.max) {
            return;
        }
        try {
            int chunkSizeCorrected = Math.min(size, this.chunkSize);
            int i = 0;
            while (i < chunkSizeCorrected) {
                this.waterfall(this.last.ce);
                this.map.remove(this.last.ce.getKey());
                this.removeNode(this.last);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void put(Serializable key, Serializable val) {
        LRUElement le = new LRUElement(key, val);
        this.update(le);
    }

    public Serializable get(Serializable key) {
        return this.get(key, false);
    }

    public Serializable get(Serializable key, boolean container) {
        LRUElementDescriptor me = null;
        ILRUElement ce = null;
        boolean found = false;
        try {
            me = (LRUElementDescriptor)this.map.get(key);
            if (me != null) {
                found = true;
                ce = me.ce;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!found) {
            return null;
        }
        try {
            this.makeFirst(me);
        }
        catch (Exception e) {
            return null;
        }
        if (container) {
            return ce;
        }
        return ce.getVal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Serializable key) throws IOException {
        boolean removed = false;
        if (key instanceof String && key.toString().endsWith(NAME_COMPONENT_DELIMITER)) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !k.toString().startsWith(key.toString())) continue;
                    itr.remove();
                    this.removeNode((LRUElementDescriptor)entry.getValue());
                    removed = true;
                }
            }
        } else {
            LRUElementDescriptor ce = (LRUElementDescriptor)this.map.remove(key);
            if (ce != null) {
                this.removeNode(ce);
                removed = true;
            }
        }
        return removed;
    }

    public void removeAll() throws IOException {
        this.map = new HashMap();
    }

    public void dispose() throws IOException {
    }

    public String getStats() {
        return "";
    }

    public int getSize() {
        return this.map.size();
    }

    public int getStatus() {
        return 0;
    }

    public Iterator getIterator() {
        return this.map.entrySet().iterator();
    }

    private void removeNode(LRUElementDescriptor me) {
        if (me.next == null) {
            if (me.prev == null) {
                this.last = null;
                this.first = null;
            } else {
                this.last = me.prev;
                this.last.next = null;
                me.prev = null;
            }
        } else if (me.prev == null) {
            this.first = me.next;
            this.first.prev = null;
            me.next = null;
        } else {
            me.prev.next = me.next;
            me.next.prev = me.prev;
            me.next = null;
            me.prev = null;
        }
    }

    private void addLast(ILRUElement ce) {
        LRUElementDescriptor me = new LRUElementDescriptor(ce);
        if (this.first == null) {
            this.first = me;
        } else {
            this.last.next = me;
            me.prev = this.last;
        }
        this.last = me;
    }

    private void addFirst(ILRUElement ce) {
        LRUElementDescriptor me = new LRUElementDescriptor(ce);
        if (this.last == null) {
            this.last = me;
        } else {
            this.first.prev = me;
            me.next = this.first;
        }
        this.first = me;
    }

    public synchronized void makeFirst(ILRUElement ce) {
        this.makeFirst(new LRUElementDescriptor(ce));
    }

    public synchronized void makeFirst(LRUElementDescriptor me) {
        try {
            if (me.prev == null) {
                return;
            }
            me.prev.next = me.next;
            if (me.next == null) {
                this.last = me.prev;
                this.last.next = null;
            } else {
                me.next.prev = me.prev;
            }
            this.first.prev = me;
            me.next = this.first;
            me.prev = null;
            this.first = me;
        }
        catch (Exception e) {}
    }

    public void waterfall(Object obj) {
    }

    public void dumpMap() {
        LRUStore.p("dumpingMap");
        Iterator itr = this.map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            LRUElementDescriptor me = (LRUElementDescriptor)e.getValue();
            LRUStore.p("dumpMap> key=" + e.getKey() + ", val=" + me.ce.getVal());
        }
    }

    public void dumpEntries() {
        LRUStore.p("dumpingEntries");
        LRUElementDescriptor me = this.first;
        while (me != null) {
            LRUStore.p("dumpEntries> key=" + me.ce.getKey() + ", val=" + me.ce.getVal());
            me = me.next;
        }
    }

    public static void p(String s) {
        System.out.println("LRUStore: " + s);
    }
}

