/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util;

import org.apache.commons.lang.StringUtils;

public class XmlUtils {
    public static String escapeXml(String str) {
        str = StringUtils.replace(str, "&", "&amp;");
        str = StringUtils.replace(str, "<", "&lt;");
        str = StringUtils.replace(str, ">", "&gt;");
        str = StringUtils.replace(str, "\"", "&quot;");
        str = StringUtils.replace(str, "'", "&apos;");
        return str;
    }

    public static String unescapeXml(String str) {
        str = StringUtils.replace(str, "&amp;", "&");
        str = StringUtils.replace(str, "&lt;", "<");
        str = StringUtils.replace(str, "&gt;", ">");
        str = StringUtils.replace(str, "&quot;", "\"");
        str = StringUtils.replace(str, "&apos;", "'");
        return str;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeXml(String str) {
        sz = str.length();
        buffer = new StringBuffer(sz);
        inString = false;
        inTag = false;
        i = 0;
        while (i < sz) {
            block4: {
                ch = str.charAt(i);
                if (ch != '<') break block4;
                inTag = true;
                ** GOTO lbl-1000
            }
            if (ch == '>') {
                inTag = false;
            } else if (!inTag) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getContent(String tag, String text) {
        int idx = XmlUtils.getIndexOpeningTag(tag, text);
        if (idx == -1) {
            return "";
        }
        text = text.substring(idx);
        int end = XmlUtils.getIndexClosingTag(tag, text);
        idx = text.indexOf(62);
        if (idx == -1) {
            return "";
        }
        return text.substring(idx + 1, end);
    }

    public static int getIndexOpeningTag(String tag, String text) {
        return XmlUtils.getIndexOpeningTag(tag, text, 0);
    }

    private static int getIndexOpeningTag(String tag, String text, int start) {
        int idx = text.indexOf("<" + tag, start);
        if (idx == -1) {
            return -1;
        }
        char next = text.charAt(idx + 1 + tag.length());
        if (next == '>' || Character.isWhitespace(next)) {
            return idx;
        }
        return XmlUtils.getIndexOpeningTag(tag, text, idx + 1);
    }

    public static int getIndexClosingTag(String tag, String text) {
        return XmlUtils.getIndexClosingTag(tag, text, 0);
    }

    public static int getIndexClosingTag(String tag, String text, int start) {
        String open = "<" + tag;
        String close = "</" + tag + ">";
        int closeSz = close.length();
        int nextCloseIdx = text.indexOf(close, start);
        if (nextCloseIdx == -1) {
            return -1;
        }
        int count = StringUtils.countMatches(text.substring(start, nextCloseIdx), open);
        if (count == 0) {
            return -1;
        }
        int expected = 1;
        while (count != expected) {
            if ((nextCloseIdx = text.indexOf(close, nextCloseIdx + closeSz)) == -1) {
                return -1;
            }
            count = StringUtils.countMatches(text.substring(start, nextCloseIdx), open);
            ++expected;
        }
        return nextCloseIdx;
    }

    public static String getAttribute(String attribute, String text) {
        return XmlUtils.getAttribute(attribute, text, 0);
    }

    public static String getAttribute(String attribute, String text, int idx) {
        int close = text.indexOf(">", idx);
        int attrIdx = text.indexOf(attribute + "=\"", idx);
        if (attrIdx == -1) {
            return null;
        }
        if (attrIdx > close) {
            return null;
        }
        int attrStartIdx = attrIdx + attribute.length() + 2;
        int attrCloseIdx = text.indexOf("\"", attrStartIdx);
        if (attrCloseIdx > close) {
            return null;
        }
        return XmlUtils.unescapeXml(text.substring(attrStartIdx, attrCloseIdx));
    }
}

