/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class WordWrapUtils {
    public static String wrapText(String str, String newline, int wrapColumn) {
        StringTokenizer lineTokenizer = new StringTokenizer(str, newline, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (lineTokenizer.hasMoreTokens()) {
            try {
                String nextLine = lineTokenizer.nextToken();
                if (nextLine.length() > wrapColumn) {
                    nextLine = WordWrapUtils.wrapLine(nextLine, newline, wrapColumn);
                }
                stringBuffer.append(nextLine);
            }
            catch (NoSuchElementException nsee) {
                break;
            }
        }
        return stringBuffer.toString();
    }

    private static String wrapLine(String line, String newline, int wrapColumn) {
        StringBuffer wrappedLine = new StringBuffer();
        while (line.length() > wrapColumn) {
            int spaceToWrapAt = line.lastIndexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            spaceToWrapAt = line.indexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            wrappedLine.append(line);
            line = "";
        }
        wrappedLine.append(line);
        return wrappedLine.toString();
    }

    public static String wordWrap(String str) {
        return WordWrapUtils.wordWrap(str, 80, "\n", "-");
    }

    public static String wordWrap(String str, int width) {
        return WordWrapUtils.wordWrap(str, width, "\n", "-");
    }

    public static String wordWrap(String str, int width, String delim, String split) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz / ++width * delim.length() + sz);
        width -= delim.length();
        int idx = -1;
        String substr = null;
        int i = 0;
        while (i < sz) {
            if (i > sz - width) {
                buffer.append(str.substring(i));
                break;
            }
            substr = str.substring(i, i + width);
            idx = substr.indexOf(delim);
            if (idx != -1) {
                buffer.append(substr.substring(0, idx));
                buffer.append(delim);
                i -= width - idx - delim.length();
                if (substr.charAt(idx + 1) != '\n' && Character.isWhitespace(substr.charAt(idx + 1))) {
                    ++i;
                }
            } else {
                idx = -1;
                char[] chrs = substr.toCharArray();
                int j = width;
                while (j > 0) {
                    if (Character.isWhitespace(chrs[j - 1])) {
                        idx = j;
                        break;
                    }
                    --j;
                }
                if (idx == -1) {
                    int j2 = width;
                    while (j2 > 0) {
                        if (chrs[j2 - 1] == '-') {
                            idx = j2;
                            break;
                        }
                        --j2;
                    }
                    if (idx == -1) {
                        buffer.append(substr);
                        buffer.append(delim);
                    } else {
                        if (idx != width) {
                            ++idx;
                        }
                        buffer.append(substr.substring(0, idx));
                        buffer.append(delim);
                        i -= width - idx;
                    }
                } else {
                    buffer.append(substr.substring(0, idx));
                    buffer.append(StringUtils.repeat(" ", width - idx));
                    buffer.append(delim);
                    i -= width - idx;
                }
            }
            i += width;
        }
        return buffer.toString();
    }
}

