/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.web;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.springframework.web.servlet.view.AbstractView;

public class ListView<T>
extends AbstractView {
    private String lineSeparator = "\n";
    private String separator = " ";
    private String title;
    private List<NameGenerator<T>> nameGenerators;

    public ListView() {
        this.setContentType("text/plain");
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contentType = this.getContentType();
        if (contentType == null || !contentType.equalsIgnoreCase("text/plain")) {
            throw new Exception("Content Type must be text/plain");
        }
        if (model.size() > 1) {
            throw new Exception("View allows only zero to one Collection");
        }
        PrintWriter printWriter = response.getWriter();
        if (this.title != null) {
            printWriter.print(this.title);
            printWriter.print(this.lineSeparator);
        }
        if (!model.isEmpty()) {
            Object o = model.values().iterator().next();
            if (!(o instanceof Collection)) {
                throw new Exception("View allows only zero to one Collection");
            }
            Collection collection = (Collection)o;
            if (this.nameGenerators == null) {
                printWriter.write(StringUtil.implode(collection, this.lineSeparator));
            } else if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                Object t = iterator.next();
                printWriter.print(this.createLine(t));
                while (iterator.hasNext()) {
                    t = iterator.next();
                    printWriter.print(this.lineSeparator);
                    printWriter.print(this.createLine(t));
                }
            }
        }
        printWriter.flush();
    }

    private String createLine(T t) {
        ArrayList<String> parts = new ArrayList<String>(this.nameGenerators.size());
        for (NameGenerator<T> nameGenerator : this.nameGenerators) {
            parts.add(nameGenerator.getName(t));
        }
        return StringUtil.implode(parts, this.separator);
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setNameGenerators(List<NameGenerator<T>> nameGenerators) {
        this.nameGenerators = nameGenerators;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

