/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.visitor;

import de.datomino.util.visitor.ReflectionVisitorNodeDetector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DefaultReflectionVisitorNodeDetector
implements ReflectionVisitorNodeDetector {
    private Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
    private Set<Class<?>> classes = new HashSet();

    public DefaultReflectionVisitorNodeDetector(Collection<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            if (clazz.isAnnotation()) {
                Class<?> annotationClass = clazz;
                this.annotations.add(annotationClass);
                continue;
            }
            this.classes.add(clazz);
        }
    }

    public DefaultReflectionVisitorNodeDetector(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    @Override
    public boolean isNode(Object o, Method getter) {
        if (o != null) {
            Class<?> clazz = o.getClass();
            for (Class<?> aClasses : this.classes) {
                if (!aClasses.isAssignableFrom(clazz)) continue;
                return true;
            }
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!this.annotations.contains(annotation.annotationType())) continue;
                return true;
            }
            for (Annotation annotation : getter.getAnnotations()) {
                if (!this.annotations.contains(annotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }
}

