/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.time;

import de.datomino.util.time.TimeUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class HolidayUtil {
    private HolidayUtil() {
    }

    public static boolean isAllSaintsDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 10 && cal.get(5) == 1;
    }

    private static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static boolean isAscensionDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        Calendar eastern = HolidayUtil.getEastern(cal.get(1));
        eastern.add(6, 39);
        return TimeUtil.isSameDay(cal, eastern);
    }

    private static Calendar getEastern(int year) {
        int a = year % 19;
        int k = year / 100;
        int p = (8 * k + 13) / 25;
        int q = k / 4;
        int m = (15 + k - p - q) % 30;
        int d = (19 * a + m) % 30;
        int b = year % 4;
        int c = year % 7;
        int n = (4 + k - q) % 7;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        int eastern = 22 + d + e;
        if (eastern > 31) {
            return new GregorianCalendar(year, 3, eastern - 31);
        }
        return new GregorianCalendar(year, 2, eastern);
    }

    public static boolean isAssumptionDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 7 && cal.get(5) == 15;
    }

    public static boolean isCorpusChristi(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        Calendar eastern = HolidayUtil.getEastern(cal.get(1));
        eastern.add(6, 60);
        return TimeUtil.isSameDay(cal, eastern);
    }

    public static boolean isEasterMonday(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        Calendar eastern = HolidayUtil.getEastern(cal.get(1));
        eastern.add(6, 1);
        return TimeUtil.isSameDay(cal, eastern);
    }

    public static boolean isFirstChristmasDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 11 && cal.get(5) == 25;
    }

    public static boolean isGermanUnityDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 9 && cal.get(5) == 3;
    }

    public static boolean isGoodFriday(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        Calendar eastern = HolidayUtil.getEastern(cal.get(1));
        eastern.add(6, -2);
        return TimeUtil.isSameDay(cal, eastern);
    }

    public static boolean isLaborDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 4 && cal.get(5) == 1;
    }

    public static boolean isNewYear(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 0 && cal.get(5) == 1;
    }

    public static boolean isPeacePartyDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 7 && cal.get(5) == 8;
    }

    public static boolean isPenanceDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        GregorianCalendar penanceDay = new GregorianCalendar(cal.get(1), 10, 22);
        while (penanceDay.get(7) != 4) {
            penanceDay.add(6, -1);
        }
        return TimeUtil.isSameDay(cal, penanceDay);
    }

    public static boolean isReformationDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 9 && cal.get(5) == 31;
    }

    public static boolean isSecondChristmasDay(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 11 && cal.get(5) == 26;
    }

    public static boolean isThreeHolyKings(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        return cal.get(2) == 0 && cal.get(5) == 3;
    }

    public static boolean isWhitMonday(Date date) {
        Calendar cal = HolidayUtil.toCalendar(date);
        Calendar eastern = HolidayUtil.getEastern(cal.get(1));
        eastern.add(6, 49);
        return TimeUtil.isSameDay(cal, eastern);
    }
}

