/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing.list;

import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class ListDialog<T>
extends JDialog {
    private static final long serialVersionUID = 867693959971456865L;
    private JList list;

    public ListDialog(Window parent, String title, Collection<T> elements) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.buildLayout();
        this.setData(elements);
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    private void setData(Collection<T> elements) {
        DefaultListModel<Wrapper> dlm = new DefaultListModel<Wrapper>();
        for (T t : elements) {
            dlm.addElement(new Wrapper(t));
        }
        this.list.setModel(dlm);
    }

    private void buildLayout() {
        super.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.list = new JList();
        panel.add((Component)new JScrollPane(this.list), "Center");
        super.getContentPane().add((Component)panel, "Center");
        panel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout());
        JButton cancel = new JButton(new AbstractAction("Abbrechen"){
            private static final long serialVersionUID = 652013566223756276L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.dispose();
            }
        });
        panel2.add(cancel);
        JButton ok = new JButton(new AbstractAction("Ok"){
            private static final long serialVersionUID = 3643474606812747324L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.performOkAction();
            }
        });
        panel2.add(ok);
        panel.add((Component)panel2, "East");
        this.getContentPane().add((Component)panel, "South");
    }

    protected abstract void performOkAction();

    protected abstract String getStringRepresentation(T var1);

    protected JList getList() {
        return this.list;
    }

    protected class Wrapper {
        private T t;

        public Wrapper(T t) {
            this.t = t;
        }

        public T getT() {
            return this.t;
        }

        public String toString() {
            return ListDialog.this.getStringRepresentation(this.getT());
        }
    }
}

