/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TableHeaderWithComponentLayout
extends BorderLayout {
    private static final long serialVersionUID = -4524714481860376161L;
    private Insets margin = new Insets(1, 1, 1, 1);
    private Map<Component, Integer> components = new HashMap<Component, Integer>();

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof Integer)) {
            throw new IllegalArgumentException("Wrong type: Integer expected");
        }
        this.components.put(comp, (Integer)constraints);
    }

    @Override
    public void layoutContainer(Container parent) {
        JTableHeader th = (JTableHeader)parent;
        th.setReorderingAllowed(false);
        JTable table = th.getTable();
        int componentCount = th.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            int viewIndex;
            Component comp = th.getComponent(i);
            Integer columnIndexObj = this.components.get(comp);
            int colIndex = columnIndexObj == null ? -1 : columnIndexObj;
            int n = viewIndex = table == null ? -1 : table.convertColumnIndexToView(colIndex);
            if (colIndex < 0 || viewIndex < 0 || viewIndex >= table.getColumnCount()) {
                comp.setBounds(0, 0, 0, 0);
                continue;
            }
            Rectangle rect = th.getHeaderRect(viewIndex);
            TableColumn draggedColumn = th.getDraggedColumn();
            if (draggedColumn != null && draggedColumn.getModelIndex() == colIndex) {
                rect.x += th.getDraggedDistance();
                th.setComponentZOrder(comp, 0);
            }
            rect.x += this.margin.left;
            rect.y += this.margin.top;
            rect.width -= this.margin.left + this.margin.right;
            rect.height -= this.margin.top + this.margin.bottom;
            Dimension size = comp.getPreferredSize();
            if (rect.height > size.height) {
                rect.y += rect.height - size.height;
                rect.height = size.height;
            }
            comp.setBounds(rect);
        }
    }
}

