/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.swing;

import de.datomino.util.swing.SpringUtilities;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DoubleList<T>
extends JPanel {
    private static final long serialVersionUID = -2218177746412405296L;
    private JList leftList;
    private JList rightList;
    private Action leftToRightAction;
    private Action rightToLeftAction;
    private Action allLeftToRightAction;
    private Action allRightToLeftAction;

    public DoubleList() {
        super(new SpringLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        DoubleListSelectionListener listSelectionListener = new DoubleListSelectionListener();
        this.leftList = new JList(new DefaultListModel());
        this.leftList.setSelectionMode(2);
        this.leftList.addListSelectionListener(listSelectionListener);
        this.add(new JScrollPane(this.leftList));
        JPanel buttonPanel = new JPanel(new SpringLayout());
        this.allLeftToRightAction = new MoveAction(">>", Direction.LEFT_TO_RIGHT, true);
        buttonPanel.add(new JButton(this.allLeftToRightAction));
        this.leftToRightAction = new MoveAction(">", Direction.LEFT_TO_RIGHT, false);
        buttonPanel.add(new JButton(this.leftToRightAction));
        this.allLeftToRightAction = new MoveAction("<", Direction.RIGHT_TO_LEFT, false);
        buttonPanel.add(new JButton(this.allLeftToRightAction));
        this.allRightToLeftAction = new MoveAction("<<", Direction.RIGHT_TO_LEFT, true);
        buttonPanel.add(new JButton(this.allRightToLeftAction));
        SpringUtilities.makeCompactGrid(buttonPanel, 4, 1, 2, 2, 2, 2);
        JPanel outerButtonPanel = new JPanel(new SpringLayout());
        outerButtonPanel.add(new JPanel());
        outerButtonPanel.add(buttonPanel);
        outerButtonPanel.add(new JPanel());
        SpringUtilities.makeCompactGrid(outerButtonPanel, 3, 1, 2, 2, 2, 2);
        this.add(outerButtonPanel);
        this.rightList = new JList(new DefaultListModel());
        this.rightList.setSelectionMode(2);
        this.rightList.addListSelectionListener(listSelectionListener);
        this.add(new JScrollPane(this.rightList));
        SpringUtilities.makeCompactGrid(this, 1, 3, 5, 5, 2, 2);
        this.doActionEnablings();
    }

    private void doActionEnablings() {
        boolean enabled = this.isEnabled();
        DefaultListModel leftDlm = (DefaultListModel)this.leftList.getModel();
        this.allLeftToRightAction.setEnabled(enabled && !leftDlm.isEmpty());
        this.leftToRightAction.setEnabled(enabled && !this.leftList.isSelectionEmpty());
        DefaultListModel rightDlm = (DefaultListModel)this.rightList.getModel();
        this.allRightToLeftAction.setEnabled(enabled && !rightDlm.isEmpty());
        this.rightToLeftAction.setEnabled(enabled && !this.rightList.isSelectionEmpty());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.leftList.setEnabled(enabled);
        this.rightList.setEnabled(enabled);
        this.doActionEnablings();
    }

    public void setLeftValues(Collection<T> leftValues) {
        this.setValues(leftValues, (DefaultListModel)this.leftList.getModel());
    }

    public void setRightValues(Collection<T> rightValues) {
        this.setValues(rightValues, (DefaultListModel)this.rightList.getModel());
    }

    private void setValues(Collection<T> values, DefaultListModel model) {
        model.removeAllElements();
        for (T t : values) {
            model.addElement(t);
        }
    }

    public Collection<T> getLeftValues() {
        return this.getValues((DefaultListModel)this.leftList.getModel());
    }

    public Collection<T> getRightValues() {
        return this.getValues((DefaultListModel)this.rightList.getModel());
    }

    private Collection<T> getValues(DefaultListModel model) {
        Enumeration en = model.elements();
        ArrayList list = new ArrayList(model.getSize());
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    private class DoubleListSelectionListener
    implements ListSelectionListener {
        private DoubleListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DoubleList.this.doActionEnablings();
        }
    }

    private class MoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 7942446929123465141L;
        private boolean all;
        private Direction direction;

        public MoveAction(String name, Direction direction, boolean all) {
            super(name);
            this.direction = direction;
            this.all = all;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList fromList = null;
            DefaultListModel from = null;
            DefaultListModel to = null;
            switch (this.direction) {
                case LEFT_TO_RIGHT: {
                    from = (DefaultListModel)DoubleList.this.leftList.getModel();
                    fromList = DoubleList.this.leftList;
                    to = (DefaultListModel)DoubleList.this.rightList.getModel();
                    break;
                }
                case RIGHT_TO_LEFT: {
                    from = (DefaultListModel)DoubleList.this.rightList.getModel();
                    fromList = DoubleList.this.rightList;
                    to = (DefaultListModel)DoubleList.this.leftList.getModel();
                }
            }
            if (this.all) {
                Enumeration en = from.elements();
                while (en.hasMoreElements()) {
                    to.addElement(en.nextElement());
                }
                from.removeAllElements();
            } else {
                Object[] selecteds;
                for (Object selected : selecteds = fromList.getSelectedValues()) {
                    from.removeElement(selected);
                    to.addElement(selected);
                }
            }
        }
    }

    private static enum Direction {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

