/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.server;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKeeperBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileKeeperBean.class);
    private File directory;
    private String baseDirectory = "/var/tomcat/";
    private String applicationName;
    private static String servletName;

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public static void setServletName(String servletName) {
        FileKeeperBean.servletName = servletName;
    }

    private synchronized File getDirectory() {
        if (this.directory == null) {
            this.directory = new File(this.baseDirectory + "/" + this.applicationName + "/" + (servletName == null ? "local" : servletName));
            if (!this.directory.exists()) {
                this.directory.mkdirs();
            } else if (!this.directory.isDirectory()) {
                throw new RuntimeException(this.directory.getAbsolutePath() + " is not a directory");
            }
        }
        return this.directory;
    }

    public File getFileForName(String name) {
        File file = new File(this.getDirectory(), name);
        LOGGER.debug("Getting file " + file.getAbsolutePath());
        return file;
    }
}

