/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.search;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchResult
implements Comparable<SearchResult> {
    public static final String COUNTRY_STR = "country";
    public static final String POSTCODE_STR = "postcode";
    public static final String CITY_STR = "city";
    public static final String DISTRICT_STR = "district";
    public static final String STREET_STR = "street";
    public static final String HOUSE_NUMBER_STR = "houseNumber";
    public static final String HOUSE_NUMBER_EXT_STR = "houseNumberExtension";
    public static final String LONGITUDE_STR = "lon";
    public static final String LATITUDE_STR = "lat";
    public static final String MATCHING_STR = "matching";
    @JsonProperty(value="country")
    private String country;
    @JsonProperty(value="houseNumberExtension")
    private String houseNumberExtension;
    @JsonProperty(value="city")
    private String city;
    @JsonProperty(value="street")
    private String street;
    @JsonProperty(value="district")
    private String district;
    @JsonProperty(value="postcode")
    private String postcode;
    @JsonProperty(value="houseNumber")
    private String houseNumber;
    private Coordinate coordinate;
    @JsonProperty(value="matching")
    private double matching;
    @JsonProperty(value="lon")
    private Double lon;
    @JsonProperty(value="lat")
    private Double lat;

    public SearchResult(String country, String postcode, String city, String district, String street, String houseNumber, String houseNumberExtension, Coordinate coordinate, double matching) {
        this.country = country;
        this.postcode = postcode;
        this.city = city;
        this.district = district;
        this.street = street;
        this.houseNumber = houseNumber;
        this.houseNumberExtension = houseNumberExtension;
        this.coordinate = coordinate;
        this.matching = matching;
    }

    public SearchResult() {
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(COUNTRY_STR, this.country);
        map.put(POSTCODE_STR, this.postcode);
        map.put(CITY_STR, this.city);
        map.put(DISTRICT_STR, this.district);
        map.put(STREET_STR, this.street);
        map.put(HOUSE_NUMBER_STR, this.houseNumber);
        map.put(HOUSE_NUMBER_EXT_STR, this.houseNumberExtension);
        if (this.coordinate != null) {
            Coordinate coord = Wgs84Factory.INSTANCE.createCoordinate(this.coordinate);
            map.put(LONGITUDE_STR, Double.toString(coord.getX()));
            map.put(LATITUDE_STR, Double.toString(coord.getY()));
        } else if (this.lon != null && this.lat != null) {
            map.put(LONGITUDE_STR, Double.toString(this.lon));
            map.put(LATITUDE_STR, Double.toString(this.lat));
        }
        map.put(MATCHING_STR, Double.toString(this.matching));
        return map;
    }

    @Override
    public int compareTo(SearchResult o) {
        return Double.compare(this.matching, o.matching);
    }
}

