/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.resolver;

import de.datomino.util.resolver.AbstractEnumResolver;
import de.datomino.util.resolver.DurationType;

public class DurationResolver
extends AbstractEnumResolver<Integer, DurationType> {
    private static final DurationResolver INSTANCE = new DurationResolver();

    protected DurationResolver() {
        super(DurationType.class);
    }

    @Override
    public Integer resolve(String value, DurationType hint) {
        Integer valueAsInt = null;
        try {
            valueAsInt = Integer.valueOf(value);
            if (hint == null) {
                hint = DurationType.MINUTES;
            }
            switch (hint) {
                case SECONDS: {
                    return valueAsInt;
                }
                case MINUTES: {
                    return valueAsInt * 60;
                }
                case HOURS: {
                    return valueAsInt * 60 * 60;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return valueAsInt;
    }

    public static DurationResolver getInstance() {
        return INSTANCE;
    }
}

