/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Set<Method> getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Method[] methods = clazz.getMethods();
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    public static Set<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Field[] fields = clazz.getDeclaredFields();
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static Set<String> getPropertiesWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass, boolean withSetters, boolean withGetters, boolean withFields) {
        HashSet<String> properties = new HashSet<String>();
        if (withSetters || withGetters) {
            Set<Method> methods = ReflectionUtil.getMethodsWithAnnotation(clazz, annotationClass);
            for (Method method : methods) {
                String name = method.getName();
                if ((!withSetters || !name.startsWith("set")) && (!withGetters || !name.startsWith("get") && !name.startsWith("is"))) continue;
                properties.add(ReflectionUtil.extractPropertyName(name));
            }
        }
        if (withFields) {
            Set<Field> fields = ReflectionUtil.getFieldsWithAnnotation(clazz, annotationClass);
            for (Field field : fields) {
                properties.add(field.getName());
            }
        }
        return properties;
    }

    public static Set<Method> findMethodsByName(Class<?> clazz, String pattern) {
        Method[] methods = clazz.getMethods();
        HashSet<Method> matchingMethods = new HashSet<Method>();
        for (Method method : methods) {
            if (!method.getName().matches(pattern)) continue;
            matchingMethods.add(method);
        }
        return matchingMethods;
    }

    public static void setProperty(Object target, String property, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Set<Method> methods = ReflectionUtil.findMethodsByName(target.getClass(), "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
        Method setMethod = null;
        for (Method method : methods) {
            if (method.getParameterTypes().length != 1) continue;
            if (setMethod == null) {
                setMethod = method;
                continue;
            }
            throw new RuntimeException("more than one setter found");
        }
        if (setMethod == null) {
            throw new NoSuchMethodException();
        }
        setMethod.invoke(target, value);
    }

    public static void setPropertyByField(Object target, String property, Object value) throws SecurityException, NoSuchFieldException, IllegalAccessException {
        Field field = null;
        boolean accessible = false;
        Class<?> clazz = target.getClass();
        do {
            try {
                field = clazz.getDeclaredField(property);
            }
            catch (NoSuchFieldException nsfe) {
                if (clazz == Object.class) break;
                clazz = clazz.getSuperclass();
                continue;
            }
            accessible = field.isAccessible();
            if (accessible) continue;
            field.setAccessible(true);
        } while (field == null);
        if (field == null) {
            throw new NoSuchFieldException(property);
        }
        field.set(target, value);
        if (!accessible) {
            field.setAccessible(false);
        }
    }

    public static void setPropertyWithFieldFallback(Object target, String property, Object value) throws SecurityException, NoSuchFieldException, IllegalAccessException {
        try {
            ReflectionUtil.setProperty(target, property, value);
        }
        catch (Exception e) {
            ReflectionUtil.setPropertyByField(target, property, value);
        }
    }

    public static Set<String> getPropertiesWithAnnotationForGettersAndFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ReflectionUtil.getPropertiesWithAnnotation(clazz, annotationClass, false, true, true);
    }

    public static String extractPropertyName(String methodName) {
        int cut;
        int methodNameLength = methodName.length();
        if ((methodName.startsWith("set") || methodName.startsWith("get")) && methodNameLength > 3) {
            cut = 3;
        } else if (methodName.startsWith("is") && methodNameLength > 2) {
            cut = 2;
        } else {
            throw new IllegalArgumentException("Method name must start with set, get or is");
        }
        String property = methodName.substring(cut);
        return Character.toLowerCase(property.charAt(0)) + property.substring(1, property.length());
    }

    public static String extractPropertyName(Method method) {
        return ReflectionUtil.extractPropertyName(method.getName());
    }

    public static Object getPropertyValue(Object o, String property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Set<Method> methods = ReflectionUtil.findMethodsByName(o.getClass(), "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
        if (methods.isEmpty()) {
            methods = ReflectionUtil.findMethodsByName(o.getClass(), "is" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
        }
        Method method = methods.iterator().next();
        return method.invoke(o, new Object[0]);
    }
}

