/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.message;

import de.datomino.util.message.Message;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class XmlMessageResolverImpl
implements MessageResolver {
    private MessageResolver messageResolver;

    public XmlMessageResolverImpl(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    @Override
    public String resolveMessage(String key, Serializable ... args) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessage(key, args));
    }

    @Override
    public String resolveMessages(List<String> keys, String ... args) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessages(keys, args));
    }

    @Override
    public String resolveMessages(ErrorMessages errorMessages, String glue) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessages(errorMessages, glue));
    }

    @Override
    public String resolveMessage(Message messages) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessage(messages));
    }

    @Override
    public List<String> resolveMessages(Collection<? extends Message> messages) {
        List<String> stringMessages = this.messageResolver.resolveMessages(messages);
        ArrayList<String> encodedMessages = new ArrayList<String>(stringMessages.size());
        for (String stringMessage : stringMessages) {
            encodedMessages.add(XmlMessageResolverImpl.encodeToXml(stringMessage));
        }
        return encodedMessages;
    }

    @Override
    public String resolveMessages(ErrorMessages errorMessages, String glue, int maxNumberOfDetailedMessages) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessages(errorMessages, glue, maxNumberOfDetailedMessages));
    }

    @Override
    public String getLocaleString() {
        return this.messageResolver.getLocaleString();
    }

    @Override
    public String resolveMessageForEnum(Enum<?> e, Serializable ... args) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessageForEnum(e, args));
    }

    @Override
    public String resolveMessageForEnum(Enum<?> e) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessageForEnum(e));
    }

    @Override
    public String resolveMessageForEnum(Class<? extends Enum<?>> clazz) {
        return XmlMessageResolverImpl.encodeToXml(this.messageResolver.resolveMessageForEnum(clazz));
    }

    private static String encodeToXml(String string) {
        return StringEscapeUtils.escapeXml(string);
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.messageResolver.getNumberFormat();
    }
}

