/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.license;

import de.datomino.lic.LicenseObjectDto;
import de.datomino.util.configuration.DatominoInitializerServlet;
import de.datomino.util.crypt.CryptUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.PrivateKey;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.io.CsvReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseUtil.class);

    private LicenseUtil() {
    }

    public static LicenseObjectDto getLicenseObject(CheckType checkType, File licenseFile) {
        return LicenseUtil.getLicenseObject(checkType, licenseFile, false);
    }

    public static LicenseObjectDto getLicenseObject(CheckType checkType, File licenseFile, boolean throwExceptionOnError) {
        PrivateKey privKey;
        if (!licenseFile.exists()) {
            LOGGER.warn("License file does not exist! Expected location: " + licenseFile.getAbsolutePath());
            if (throwExceptionOnError) {
                throw new RuntimeException("License file does not exist");
            }
            return LicenseObjectDto.createEmptyLicenseObjectDto();
        }
        try {
            privKey = CryptUtil.readPrivateKeyFromInputStream(LicenseUtil.class.getResourceAsStream("/license/lic.priv"));
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Key class not found!");
            return LicenseObjectDto.createEmptyLicenseObjectDto();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), e);
            return LicenseObjectDto.createEmptyLicenseObjectDto();
        }
        try {
            byte[] decrypt = CryptUtil.decrypt(FileUtils.readFileToByteArray(licenseFile), privKey);
            String dString = new String(decrypt);
            CsvReader csvReader = new CsvReader(new StringReader(dString));
            csvReader.setDelim(Character.valueOf(';'));
            List<String> line = csvReader.readLine();
            Iterator<String> iter = line.iterator();
            int areaLicenseCount = Integer.parseInt(iter.next());
            int tourLicenseCount = Integer.parseInt(iter.next());
            int area2LicenseCount = Integer.parseInt(iter.next());
            int tour2LicenseCount = Integer.parseInt(iter.next());
            LicenseObjectDto.MobileLicenseMode mobilityLicenseMode = LicenseObjectDto.MobileLicenseMode.valueOf(iter.next());
            String mobilityLicenseCountString = iter.next();
            Integer mobilityLicenseCount = null;
            try {
                mobilityLicenseCount = Integer.valueOf(mobilityLicenseCountString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LicenseObjectDto.MobileLicenseMode trackwatchLicenseMode = LicenseObjectDto.MobileLicenseMode.valueOf(iter.next());
            String trackwatchLicenseCountString = iter.next();
            Integer trackwatchLicenseCount = null;
            try {
                trackwatchLicenseCount = Integer.valueOf(trackwatchLicenseCountString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String macAddress = iter.next();
            String deployment = iter.next();
            String mobilityDeployment = iter.next();
            String trackwatchDeployment = iter.next();
            HashSet<Long> wageLayerIds = new HashSet<Long>();
            while (iter.hasNext()) {
                wageLayerIds.add(Long.valueOf(iter.next()));
            }
            if (!LicenseUtil.checkMacAddress(macAddress)) {
                if (throwExceptionOnError) {
                    throw new RuntimeException("Mac address not matching");
                }
                return LicenseObjectDto.createEmptyLicenseObjectDto();
            }
            if (!LicenseUtil.checkDeployment(deployment, mobilityDeployment, trackwatchDeployment, checkType)) {
                if (throwExceptionOnError) {
                    throw new RuntimeException("Deployment not matching");
                }
                return LicenseObjectDto.createEmptyLicenseObjectDto();
            }
            return new LicenseObjectDto(areaLicenseCount, tourLicenseCount, area2LicenseCount, tour2LicenseCount, mobilityLicenseMode, mobilityLicenseCount, trackwatchLicenseMode, trackwatchLicenseCount, wageLayerIds, macAddress, deployment, mobilityDeployment, trackwatchDeployment);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return LicenseObjectDto.createEmptyLicenseObjectDto();
        }
    }

    private static boolean checkDeployment(String deployment, String mobilityDeployment, String trackwatchDeployment, CheckType checkType) {
        String dep = null;
        switch (checkType) {
            case DEFAULT: {
                dep = deployment;
                break;
            }
            case MOBILITY: {
                dep = mobilityDeployment;
                break;
            }
            case TRACKWATCH: {
                dep = trackwatchDeployment;
            }
        }
        String servletName = DatominoInitializerServlet.getKeyName();
        if (servletName == null) {
            servletName = "local";
        }
        if (new EqualsBuilder().append(dep, servletName).isEquals()) {
            return true;
        }
        LOGGER.warn("Deployment name does not match " + dep);
        return false;
    }

    private static boolean checkMacAddress(String macAddress) {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nextElement = networkInterfaces.nextElement();
                byte[] mac = nextElement.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                if (!new EqualsBuilder().append(macAddress.toLowerCase().replace(':', '-'), sb.toString().toLowerCase()).isEquals()) continue;
                return true;
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        LOGGER.warn("No matching mac-address for " + macAddress + " found");
        return false;
    }

    public static enum CheckType {
        DEFAULT,
        MOBILITY,
        TRACKWATCH;

    }
}

