/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ForkingInputstream
extends InputStream {
    private InputStream delegate;
    private OutputStream outcopy;

    public ForkingInputstream(InputStream delegate, OutputStream outcopy) {
        this.delegate = delegate;
        this.outcopy = outcopy instanceof BufferedOutputStream ? outcopy : new BufferedOutputStream(outcopy);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.outcopy.flush();
        this.outcopy.close();
        this.delegate.close();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int read() throws IOException {
        int r = this.delegate.read();
        if (r > -1) {
            this.outcopy.write(r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int processed = this.delegate.read(b, off, len);
        if (processed > 0) {
            this.outcopy.write(b, off, processed);
        }
        return processed;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int processed = this.delegate.read(b);
        if (processed > 0) {
            this.outcopy.write(b);
        }
        return processed;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

