/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.io;

import de.datomino.util.RandomUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static File findNextTimestampFile(String prefix, String suffix, String dir) {
        return FileUtil.findNextTimestampFile(prefix, suffix, new File(dir));
    }

    public static File findNextTimestampFile(String prefix, String suffix, File dir) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String filename = prefix + simpleDateFormat.format(new Date());
        File file = new File(dir, filename + suffix);
        int count = 0;
        while (file.exists()) {
            file = new File(dir, filename + "_" + count + suffix);
            ++count;
        }
        return file;
    }

    public static String findTimeBasedRandomString() {
        return new SimpleDateFormat("yyyyMMdd_HHmmss_SSS").format(new Date()) + "_" + RandomUtil.nextIntegerString(10001, true);
    }

    public static String getMd5Sum(File imageFile) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("md5");
        md.reset();
        byte[] bytes = FileUtils.readFileToByteArray(imageFile);
        md.update(bytes, 0, bytes.length);
        String mdString = StringUtil.toHexString(md.digest(), 32);
        return mdString;
    }

    public static boolean existsFile(File dir, String fileName) {
        File[] files;
        if (dir == null || !dir.isDirectory() || StringUtil.isBlank(fileName)) {
            return false;
        }
        for (File file : files = dir.listFiles()) {
            if (!file.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public static void moveFileUnixOnly(File source, File target) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(new String[]{"mv", source.getAbsolutePath(), target.getAbsolutePath()});
        p.waitFor();
    }

    public static byte[] readFileToByteArrayUnixOnly(File file) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(new String[]{"cat", file.getAbsolutePath()});
        byte[] b = IOUtils.toByteArray(p.getInputStream());
        p.waitFor();
        return b;
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream inputStream = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int index = 0;
            while ((index = ((InputStream)inputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, index);
            }
        }
        catch (IOException ex) {
            LOGGER.warn(ex.getMessage(), ex);
            throw ex;
        }
        finally {
            outputStream.close();
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        return outputStream.toByteArray();
    }

    public static boolean zip(String name, String zipName, boolean recursive) throws IOException {
        File src = new File(name);
        if (!src.exists()) {
            return false;
        }
        FileOutputStream fileOut = new FileOutputStream(zipName);
        ZipOutputStream zipOut = new ZipOutputStream(fileOut);
        if (src.isDirectory()) {
            FileUtil.addDirectoryToZip("", src, zipOut, recursive);
        } else {
            FileUtil.addFileToZip("", src, zipOut, false);
        }
        zipOut.close();
        fileOut.close();
        return true;
    }

    private static void addDirectoryToZip(String path, File dir, ZipOutputStream zipOut, boolean recursive) throws IOException {
        for (File file : dir.listFiles()) {
            String filePath = path + (StringUtil.isEmpty(path) ? "" : "/") + dir.getName();
            FileUtil.addFileToZip(filePath, file, zipOut, recursive);
        }
    }

    private static void addFileToZip(String path, File file, ZipOutputStream zipOut, boolean recursive) throws IOException {
        if (file.isDirectory()) {
            if (recursive) {
                FileUtil.addDirectoryToZip(path, file, zipOut, recursive);
            }
        } else {
            FileInputStream fileIn = new FileInputStream(file);
            zipOut.putNextEntry(new ZipEntry(path + "/" + file.getName()));
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = fileIn.read(buffer)) > 0) {
                zipOut.write(buffer, 0, len);
            }
            fileIn.close();
        }
    }

    public static boolean unzip(String path, File zip) throws IOException {
        if (zip == null || !zip.exists()) {
            return false;
        }
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry nextElement = entries.nextElement();
            InputStream inputStream = zipFile.getInputStream(nextElement);
            IOUtils.copy(inputStream, (OutputStream)new FileOutputStream(path + "/" + nextElement.getName()));
        }
        zipFile.close();
        return true;
    }

    public static void setRightsForEveryoneUnixOnly(File file) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(new String[]{"chmod", "666", file.getAbsolutePath()});
        p.waitFor();
    }

    public static void setRightsForEveryone(File file) throws IOException {
        Path path = FileSystems.getDefault().getPath(file.getParent(), file.getName());
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        if (file.isDirectory()) {
            perms.addAll(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
        }
        Files.setPosixFilePermissions(path, perms);
    }

    public static Collection<File> getAllFilesRek(File dir) {
        HashSet<File> walkedDirs = new HashSet<File>();
        return FileUtil.getAllFilesRek(dir, walkedDirs);
    }

    private static Collection<File> getAllFilesRek(File dir, Set<File> walkedDirs) {
        if (walkedDirs.contains(dir)) {
            return Collections.emptySet();
        }
        if (dir.isFile()) {
            return Collections.singleton(dir);
        }
        if (dir.isDirectory()) {
            walkedDirs.add(dir);
            File[] listFiles = dir.listFiles();
            TreeSet<File> files = new TreeSet<File>();
            for (File file : listFiles) {
                files.addAll(FileUtil.getAllFilesRek(file, walkedDirs));
            }
            return files;
        }
        return Collections.emptySet();
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileUtil.writeByteArrayToFile(file, data, false);
    }

    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, append);
        fos.write(data);
        fos.flush();
        fos.close();
    }

    public static Date getCreationTime(File file) throws IOException {
        BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return new Date(attr.creationTime().toMillis());
    }
}

