/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.international.country;

import de.datomino.util.international.country.Country;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CountryUtil {
    private static final String[] LOCALES = new String[]{"de", "en"};
    private static final Map<String, Country> COUNTRY_ALIAS_MAP;

    private CountryUtil() {
    }

    public static Country getCountryForAlias1(String alias) {
        if (alias == null) {
            return null;
        }
        return COUNTRY_ALIAS_MAP.get(alias);
    }

    public static Country searchCountryFuzzy(String search) {
        if (search == null) {
            return null;
        }
        Country country = CountryUtil.getCountryByIso(search = search.trim().toLowerCase());
        if (country == null && (country = CountryUtil.getCountryByVehicleSign(search)) == null) {
            String locale;
            String[] stringArray = LOCALES;
            int n = stringArray.length;
            for (int i = 0; i < n && (country = CountryUtil.getCountryByName(search, locale = stringArray[i])) == null; ++i) {
            }
            if (country == null) {
                country = CountryUtil.getCountryForAlias1(search);
            }
        }
        return country;
    }

    public static Country getCountryByIso(String iso) {
        if (iso == null) {
            return null;
        }
        for (Country country : Country.values()) {
            if (!iso.equalsIgnoreCase(country.getIso3166_2())) continue;
            return country;
        }
        return null;
    }

    public static Country getCountryByVehicleSign(String vehicleSign) {
        if (vehicleSign == null) {
            return null;
        }
        for (Country country : Country.values()) {
            if (!vehicleSign.equalsIgnoreCase(country.getVehicleSign())) continue;
            return country;
        }
        return null;
    }

    public static Country getCountryByName(String name, String locale) {
        if (name == null || locale == null) {
            return null;
        }
        for (Country country : Country.values()) {
            String lName = country.getDisplayName(locale);
            if (!name.equalsIgnoreCase(lName)) continue;
            return country;
        }
        return null;
    }

    static {
        HashMap<String, Country> map = new HashMap<String, Country>();
        for (Country country : Country.values()) {
            for (String alias : country.getAlias()) {
                map.put(alias, country);
            }
        }
        COUNTRY_ALIAS_MAP = Collections.unmodifiableMap(map);
    }
}

