/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.international.country;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public enum Country implements Serializable
{
    ALBANIA,
    ANDORRA,
    ARMENIA,
    AUSTRIA,
    AZERBAIJAN,
    BELARUS,
    BELGIUM,
    BOSNIAANDHERZEGOVINA,
    BULGARIA,
    CROATIA,
    CYPRUS,
    CZECHREPUBLIC,
    DENMARK,
    ESTONIA,
    FINLAND,
    FRANCE,
    GEORGIA,
    GERMANY,
    GREECE,
    HUNGARY,
    ICELAND,
    IRELAND,
    ITALY,
    KAZAKHSTAN,
    KOSOVO,
    LATVIA,
    LIECHTENSTEIN,
    LITHUANIA,
    LUXEMBOURG,
    MACEDONIA,
    MALTA,
    MOLDOVA,
    MONACO,
    MONTENEGRO,
    NETHERLANDS,
    NORWAY,
    POLAND,
    PORTUGAL,
    ROMANIA,
    RUSSIA,
    SANMARINO,
    SERBIA,
    SLOVAKIA,
    SLOVENIA,
    SPAIN,
    SWEDEN,
    SWITZERLAND,
    TURKEY,
    UKRAINE,
    UNITEDKINGDOM,
    VATICANCITY;

    private String[] alias;
    private Map<String, String> displayName;
    private String iso3166_2;
    private String vehicleSign;

    private Country() {
        Properties props = new Properties();
        try {
            props.load(Country.class.getResourceAsStream("/de/datomino/util/international/country/" + this.name() + ".properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.iso3166_2 = props.getProperty("iso3166_2");
        this.vehicleSign = props.getProperty("vehiclesign");
        this.displayName = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("displayname")) continue;
            String locale = key.substring(12);
            this.displayName.put(locale, entry.getValue().toString());
        }
        LinkedList<String> aliasList = new LinkedList<String>();
        String sAlias = props.getProperty("alias.0");
        int c = 1;
        while (sAlias != null) {
            aliasList.add(sAlias);
            sAlias = props.getProperty("alias." + c++);
        }
        this.alias = new String[aliasList.size()];
        aliasList.toArray(this.alias);
    }

    public String[] getAlias() {
        return this.alias;
    }

    public String getIso3166_2() {
        return this.iso3166_2;
    }

    public String getDisplayName(String locale) {
        String name = this.displayName.get(locale);
        if (name == null) {
            name = this.displayName.get("en");
        }
        return name == null ? this.toString() : name;
    }

    public String getVehicleSign() {
        return this.vehicleSign;
    }

    public String toString() {
        return this.getIso3166_2();
    }
}

