/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.util;

import de.datomino.util.geo.ImmutablePoint;
import java.util.Iterator;
import java.util.List;
import org.ktde.util.datatypes.Quad;

public class PairIterator
implements Iterator<Quad<ImmutablePoint, ImmutablePoint, Integer, Integer>> {
    private List<ImmutablePoint> points;
    private int currentPosition = 0;
    private Iterator<ImmutablePoint> iterator;
    private ImmutablePoint currentPoint;

    public PairIterator(List<ImmutablePoint> points) {
        this.points = points;
        this.iterator = points.iterator();
        this.currentPoint = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    @Override
    public boolean hasNext() {
        if (this.points.size() <= 1) {
            return false;
        }
        return this.currentPosition <= this.points.size();
    }

    @Override
    public Quad<ImmutablePoint, ImmutablePoint, Integer, Integer> next() {
        Quad<ImmutablePoint, ImmutablePoint, Integer, Integer> quad;
        if (this.currentPosition == this.points.size() - 1) {
            quad = new Quad<ImmutablePoint, ImmutablePoint, Integer, Integer>(this.currentPoint, this.points.get(0), this.points.size() - 1, 0);
        } else {
            ImmutablePoint next = this.iterator.next();
            quad = new Quad<ImmutablePoint, ImmutablePoint, Integer, Integer>(this.currentPoint, next, this.currentPosition, this.currentPosition + 1);
            this.currentPoint = next;
        }
        ++this.currentPosition;
        return quad;
    }

    @Override
    public void remove() {
        throw new RuntimeException();
    }
}

