/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.util;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.algorithm.selfintersection.SelfIntersectionKiller;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableGeometryCollection;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.BasedPoint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.ComparatorUtils;
import org.ktde.math.MathHelper;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoUtils.class);

    public static boolean areLinesParallel(ImmutableLineString l1, ImmutableLineString l2) {
        return GeoUtils.areLinesParallel(l1.getStartPoint(), l1.getEndPoint(), l2.getStartPoint(), l2.getEndPoint());
    }

    public static boolean areLinesParallel(ImmutablePoint p11, ImmutablePoint p12, ImmutablePoint p21, ImmutablePoint p22) {
        double dy2;
        double dx1 = p11.getX() - p12.getX();
        double dx2 = p21.getX() - p22.getX();
        double dy1 = p12.getY() - p11.getY();
        double det = dy1 * dx2 - (dy2 = p22.getY() - p21.getY()) * dx1;
        return det == 1.0E-7;
    }

    public static List<ImmutablePoint> intersectLines(ImmutableLineString l1, ImmutableLineString l2) {
        LinkedList<ImmutablePoint> result = new LinkedList<ImmutablePoint>();
        List<ImmutablePoint> list1 = ((ImmutableLineString)l1.getTransformed(GeoDecimalFactory.INSTANCE)).getCoordinates();
        Iterator<ImmutablePoint> iter1 = list1.iterator();
        List<ImmutablePoint> list2 = ((ImmutableLineString)l2.getTransformed(GeoDecimalFactory.INSTANCE)).getCoordinates();
        ImmutablePoint pred1 = iter1.next();
        while (iter1.hasNext()) {
            ImmutablePoint succ1 = iter1.next();
            Iterator<ImmutablePoint> iter2 = list2.iterator();
            ImmutablePoint pred2 = iter2.next();
            while (iter2.hasNext()) {
                ImmutablePoint succ2 = iter2.next();
                result.addAll(GeoUtils.intersectPoints(pred1, succ1, pred2, succ2));
                succ2 = pred2;
            }
            succ1 = pred1;
        }
        return result;
    }

    public static List<ImmutablePoint> intersectPoints(ImmutablePoint p11, ImmutablePoint p12, ImmutablePoint p21, ImmutablePoint p22) {
        LinkedList<ImmutablePoint> result = new LinkedList<ImmutablePoint>();
        if (p11.equals(p12)) {
            if (GeoUtils.isPointOnLine(p11, p21, p22)) {
                result.add(p11);
            }
        } else if (p21.equals(p22)) {
            if (GeoUtils.isPointOnLine(p21, p11, p12)) {
                result.add(p21);
            }
        } else if (p11.equals(p21)) {
            result.add(p11);
            if (GeoUtils.isPointOnLine(p12, p11, p22)) {
                result.add(p12);
            } else if (GeoUtils.isPointOnLine(p22, p11, p12)) {
                result.add(p22);
            }
        } else if (p11.equals(p22)) {
            result.add(p11);
            if (GeoUtils.isPointOnLine(p12, p11, p21)) {
                result.add(p12);
            } else if (GeoUtils.isPointOnLine(p21, p11, p12)) {
                result.add(p21);
            }
        } else if (p12.equals(p21)) {
            result.add(p12);
            if (GeoUtils.isPointOnLine(p11, p12, p22)) {
                result.add(p11);
            } else if (GeoUtils.isPointOnLine(p22, p12, p11)) {
                result.add(p22);
            }
        } else if (p12.equals(p22)) {
            result.add(p12);
            if (GeoUtils.isPointOnLine(p11, p12, p21)) {
                result.add(p11);
            } else if (GeoUtils.isPointOnLine(p21, p12, p11)) {
                result.add(p21);
            }
        } else if (GeoUtils.areLinesParallel(p11, p12, p21, p22)) {
            if (GeoUtils.isPointOnLine(p11, p21, p22)) {
                result.add(p11);
            }
            if (GeoUtils.isPointOnLine(p12, p21, p22)) {
                result.add(p12);
            }
            if (GeoUtils.isPointOnLine(p21, p11, p12)) {
                result.add(p21);
            }
            if (GeoUtils.isPointOnLine(p22, p11, p12)) {
                result.add(p22);
            }
        } else {
            double a;
            double b;
            double x11 = p11.getX();
            double y11 = p11.getY();
            double x12 = p12.getX();
            double y12 = p12.getY();
            double x21 = p21.getX();
            double y21 = p21.getY();
            double x22 = p22.getX();
            double y22 = p22.getY();
            double sa = x12 - x11;
            double sb = x21 - x22;
            double ta = y12 - y11;
            double tb = y21 - y22;
            double sc = x21 - x11;
            double tc = y21 - y11;
            if (ta == 0.0) {
                b = tc / tb;
                a = (sc - b * sb) / sa;
            } else if (tb == 0.0) {
                a = tc / ta;
                b = (sc - a * sa) / sb;
            } else {
                a = (sc - tc * sb / tb) / (sa - ta * sb / tb);
                b = (tc - a * ta) / tb;
            }
            if (MathHelper.between(a, 0.0, 1.0) && MathHelper.between(b, 0.0, 1.0)) {
                result.add(ImmutableGeoObjectFactory.createImmutablePoint(p11.getCoordinate().getFactory().createCoordinate(x11 + sa * a, y11 + ta * a)));
            }
        }
        return result;
    }

    public static boolean isPointOnLine(ImmutablePoint p, ImmutablePoint p1, ImmutablePoint p2) {
        return GeoUtils.isPointOnLine(p, p1, p2, null);
    }

    public static boolean areAllPointsOnStraight(Collection<ImmutablePoint> points) {
        if (points.isEmpty()) {
            return true;
        }
        Iterator<ImmutablePoint> iter = points.iterator();
        ImmutablePoint point1 = iter.next();
        ImmutablePoint point2 = null;
        while (iter.hasNext()) {
            ImmutablePoint next = iter.next();
            if (point1.equals(next)) continue;
            point2 = next;
            break;
        }
        if (point2 == null) {
            return true;
        }
        double vx = point2.getX() - point1.getX();
        double vy = point2.getY() - point1.getY();
        for (ImmutablePoint point : points) {
            if (vx == 0.0) {
                if (point.getX() == 0.0) continue;
                return false;
            }
            if (vy == 0.0) {
                if (point.getY() == 0.0) continue;
                return false;
            }
            double lambdaX = point.getX() - point1.getX();
            if (vx != 0.0) {
                lambdaX /= vx;
            }
            double lambdaY = point.getY() - point1.getY();
            if (vy != 0.0) {
                lambdaY /= vy;
            }
            if (lambdaX == lambdaY) continue;
            return false;
        }
        return true;
    }

    public static boolean isPointOnLine(ImmutablePoint p, ImmutablePoint p1, ImmutablePoint p2, Double tolerance) {
        boolean result = false;
        if (p.equals(p1)) {
            result = true;
        } else if (p.equals(p2)) {
            result = true;
        } else if (p1.equals(p2)) {
            result = false;
        } else {
            double x = p.getX();
            double y = p.getY();
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            if (x1 == x2) {
                if (x == x2) {
                    double a = (y - y2) / (y1 - y2);
                    result = MathHelper.between(a, 0.0, 1.0);
                }
            } else if (y1 == y2) {
                if (y == y2) {
                    double a = (x - x2) / (x1 - x2);
                    result = MathHelper.between(a, 0.0, 1.0);
                }
            } else {
                double a1 = (x - x2) / (x1 - x2);
                double a2 = (y - y2) / (y1 - y2);
                if (tolerance == null && a1 == a2 || tolerance != null && Math.abs(a1 - a2) <= tolerance) {
                    result = MathHelper.between(a1, 0.0, 1.0) && MathHelper.between(a2, 0.0, 1.0);
                }
            }
        }
        return result;
    }

    public static ImmutablePoint getAveragePointOfGivenPoints(List<ImmutablePoint> allPoints) {
        ImmutablePoint averagePoint = null;
        int size = allPoints.size();
        Double xPointsSum = 0.0;
        Double yPointsSum = 0.0;
        CoordinateFactory factory = allPoints.get(0).getCoordinateFactory();
        for (ImmutablePoint point : allPoints) {
            xPointsSum = xPointsSum + point.getX();
            yPointsSum = yPointsSum + point.getY();
        }
        Double x = xPointsSum / (double)size;
        Double y = yPointsSum / (double)size;
        Coordinate c = new Coordinate(factory, x, y);
        averagePoint = ImmutableGeoObjectFactory.createImmutablePoint(c);
        return averagePoint;
    }

    public static ImmutablePoint getBasePoint(ImmutablePoint p, ImmutablePoint p1, ImmutablePoint p2) {
        ImmutablePoint result = null;
        if (p.equals(p1)) {
            result = p1;
        } else if (p.equals(p2)) {
            result = p2;
        } else if (p1.equals(p2)) {
            result = p1;
        } else {
            double x = p.getX();
            double y = p.getY();
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            if (x1 == x2) {
                result = ImmutableGeoObjectFactory.createImmutablePoint(p1.getCoordinate().getFactory().createCoordinate(x1, y));
            } else if (y1 == y2) {
                result = ImmutableGeoObjectFactory.createImmutablePoint(p1.getCoordinate().getFactory().createCoordinate(x, y1));
            } else {
                double ux = x2 - x1;
                double uy = y2 - y1;
                double m1 = uy / ux;
                double t1 = y1 - m1 * x1;
                double m2 = -1.0 / m1;
                double t2 = y - m2 * x;
                double xs = (t2 - t1) / (m1 - m2);
                double ys = m1 * xs + t1;
                result = ImmutableGeoObjectFactory.createImmutablePoint(p1.getCoordinate().getFactory().createCoordinate(xs, ys));
            }
        }
        return result;
    }

    public static Tripel<Double, ImmutablePoint, Relation> getPointRelationDescription(ImmutablePoint p, ImmutablePoint p1, ImmutablePoint p2, CoordinateFactory commonFactory) {
        p = (ImmutablePoint)p.getTransformed(commonFactory);
        p1 = (ImmutablePoint)p1.getTransformed(commonFactory);
        p2 = (ImmutablePoint)p2.getTransformed(commonFactory);
        Tripel<Object, Object, Object> result = new Tripel<Object, Object, Object>(null, null, null);
        if (p.equals(p1)) {
            result.setElement1(0.0);
            result.setElement2(p1);
            result.setElement3(Relation.INTERVAL_START);
        } else if (p.equals(p2)) {
            result.setElement1(0.0);
            result.setElement2(p2);
            result.setElement3(Relation.INTERVAL_END);
        } else if (p1.equals(p2)) {
            result.setElement1(p.distance(p1));
            result.setElement2(p1);
            result.setElement3(Relation.INTERVAL_START);
        } else {
            ImmutablePoint basePoint = GeoUtils.getBasePoint(p, p1, p2);
            if (basePoint.equals(p1)) {
                result.setElement1(p.distance(p1));
                result.setElement2(p1);
                result.setElement3(Relation.INTERVAL_START);
            } else if (basePoint.equals(p2)) {
                result.setElement1(p.distance(p2));
                result.setElement2(p2);
                result.setElement3(Relation.INTERVAL_END);
            } else {
                double x1 = p1.getX();
                double y1 = p1.getY();
                double x2 = p2.getX();
                double y2 = p2.getY();
                double xb = basePoint.getX();
                double yb = basePoint.getY();
                double lambda = x1 == x2 ? (yb - y1) / (y2 - y1) : (xb - x1) / (x2 - x1);
                if (lambda < 0.0) {
                    result.setElement1(p.distance(p1));
                    result.setElement2(p1);
                    result.setElement3(Relation.INTERVAL_BEFORE);
                } else if (lambda > 1.0) {
                    result.setElement1(p.distance(p2));
                    result.setElement2(p2);
                    result.setElement3(Relation.INTERVAL_AFTER);
                } else {
                    result.setElement1(p.distance(basePoint));
                    result.setElement2(basePoint);
                    result.setElement3(Relation.INTERVAL_WITHIN);
                }
            }
        }
        return result;
    }

    public static double area(ImmutablePoint p1, ImmutablePoint p2, ImmutablePoint ... points) {
        ArrayList<ImmutablePoint> pointList = new ArrayList<ImmutablePoint>();
        pointList.add(p1);
        pointList.add(p2);
        pointList.addAll(Arrays.asList(points));
        return GeoUtils.area(pointList);
    }

    public static double area(List<ImmutablePoint> points) {
        ImmutablePoint prev;
        double area = 0.0;
        Iterator<ImmutablePoint> iter = points.iterator();
        ImmutablePoint start = prev = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint next = iter.next();
            area += GeoUtils.crossProduct(prev, next);
            prev = next;
        }
        if (!prev.equals(start)) {
            area += GeoUtils.crossProduct(prev, start);
        }
        return area / 2.0;
    }

    private static double crossProduct(ImmutablePoint prev, ImmutablePoint next) {
        double x1 = prev.getX();
        double y1 = prev.getY();
        double x2 = next.getX();
        double y2 = next.getY();
        double change = x1 * y2 - x2 * y1;
        return change;
    }

    public static double area(ImmutablePolygon polygon) {
        double area = GeoUtils.area(polygon.getShell().getCoordinates());
        for (ImmutableLineString hole : polygon.getHoles()) {
            area -= GeoUtils.area(hole.getCoordinates());
        }
        return area;
    }

    public static boolean isClockwise(ImmutablePolygon polygon) {
        return GeoUtils.area(polygon) < 0.0;
    }

    public static boolean isClockwise(List<ImmutablePoint> points) {
        return GeoUtils.area(points) < 0.0;
    }

    public static boolean isClockwise(ImmutablePoint point1, ImmutablePoint point2, ImmutablePoint ... points) {
        return GeoUtils.area(point1, point2, points) < 0.0;
    }

    public static BasedPoint getPointRelationDescription(ImmutableLineString baseLine, ImmutablePoint point) {
        BasedPoint basedPoint = null;
        List<ImmutablePoint> points = baseLine.getCoordinates();
        int c = points.size();
        double mindist = Double.MAX_VALUE;
        double lengthtotal = 0.0;
        for (int i = 1; i < c; ++i) {
            Tripel<Double, ImmutablePoint, Relation> rel = GeoUtils.getPointRelationDescription(point, points.get(i - 1), points.get(i), baseLine.getCoordinateFactory());
            if (mindist > rel.getElement1()) {
                Relation relation = rel.getElement3();
                if (i > 1 && (relation == Relation.INTERVAL_START || relation == Relation.INTERVAL_BEFORE) || i < c - 1 && (relation == Relation.INTERVAL_END || relation == Relation.INTERVAL_AFTER)) {
                    relation = Relation.INTERVAL_WITHIN;
                }
                basedPoint = new BasedPoint(point, rel.getElement2(), baseLine, rel.getElement1(), relation, lengthtotal + points.get(i - 1).distance(rel.getElement2()));
                mindist = rel.getElement1();
            }
            lengthtotal += points.get(i - 1).distance(points.get(i));
        }
        return basedPoint;
    }

    public static ImmutableLineString removeDeadEnds(ImmutableLineString immutableLineString) {
        return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(GeoUtils.removeDeadEnds(immutableLineString.getCoordinates(), false));
    }

    public static ImmutableLineString removeDeadEnds(ImmutableLineString immutableLineString, boolean cyclic) {
        return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(GeoUtils.removeDeadEnds(immutableLineString.getCoordinates(), cyclic));
    }

    public static ImmutablePolygon removeDeadEnds(ImmutablePolygon immutablePolygon) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygon(GeoUtils.removeDeadEnds(immutablePolygon.getShell().getCoordinates(), true));
    }

    public static List<ImmutablePoint> removeDeadEnds(List<ImmutablePoint> points, boolean cyclic) {
        if (cyclic && !points.get(0).equals(points.get(points.size() - 1))) {
            points.add(points.get(0));
        }
        List<ImmutablePoint> result = GeoUtils.removeMultiplesInARow(points, cyclic);
        TreeSet<Integer> localDeadIndices = new TreeSet<Integer>(ComparatorUtils.reversedComparator(ComparatorUtils.naturalComparator()));
        while (result.size() >= 3) {
            ImmutablePoint succ;
            ImmutablePoint second;
            ImmutablePoint first;
            Iterator<ImmutablePoint> iter = result.iterator();
            ImmutablePoint pred = first = iter.next();
            ImmutablePoint current = second = iter.next();
            int index = 1;
            localDeadIndices.clear();
            while (iter.hasNext()) {
                succ = iter.next();
                if (pred.equals(succ)) {
                    localDeadIndices.add(index);
                }
                ++index;
                pred = current;
                current = succ;
            }
            if (cyclic) {
                succ = first;
                if (pred.equals(succ)) {
                    localDeadIndices.add(index);
                }
                pred = current;
                current = succ;
                succ = second;
                if (pred.equals(succ)) {
                    localDeadIndices.add(0);
                }
            }
            if (!localDeadIndices.isEmpty()) {
                for (Integer rIndex : localDeadIndices) {
                    result.remove(rIndex);
                }
                result = GeoUtils.removeMultiplesInARow(result, cyclic);
            }
            if (!localDeadIndices.isEmpty()) continue;
        }
        return result;
    }

    private static List<ImmutablePoint> removeMultiplesInARow(List<ImmutablePoint> points, boolean cyclic) {
        ImmutablePoint lead;
        ArrayList<ImmutablePoint> newPoints = new ArrayList<ImmutablePoint>(points.size());
        if (points.size() <= 1) {
            return points;
        }
        Iterator<ImmutablePoint> iter = points.iterator();
        ImmutablePoint first = lead = iter.next();
        newPoints.add(lead);
        while (iter.hasNext()) {
            ImmutablePoint next = iter.next();
            if (lead.equals(next)) continue;
            newPoints.add(next);
            lead = next;
        }
        if (cyclic && first.equals(lead)) {
            newPoints.remove(newPoints.size() - 1);
        }
        return newPoints;
    }

    public static void assertIsValidLinestring(ImmutableGeoObject object) throws IllegalArgumentException {
        if (!(object instanceof ImmutableLineString)) {
            throw new IllegalArgumentException("Geometry is not a linestring");
        }
        ImmutablePoint lastPoint = null;
        int countpoints = 0;
        for (ImmutablePoint point : ((ImmutableLineString)object).getCoordinates()) {
            if (point.equals(lastPoint)) {
                throw new IllegalArgumentException("linestring contains equal points");
            }
            lastPoint = point;
            ++countpoints;
        }
        if (countpoints < 2) {
            throw new IllegalArgumentException("linestring contains only one distinct point");
        }
        if (!object.isSimple()) {
            throw new IllegalArgumentException("linestring is not simple");
        }
    }

    public static ImmutablePoint getPointOnLine(ImmutablePoint start, ImmutablePoint end, double percentage) {
        double startX = start.getX();
        double startY = start.getY();
        double x = end.getX() - startX;
        double y = end.getY() - startY;
        double length = Math.sqrt(x * x + y * y);
        double nLength = length * percentage;
        double nX = startX + x / length * nLength;
        double nY = startY + y / length * nLength;
        return ImmutableGeoObjectFactory.createImmutablePoint(new Coordinate(start.getCoordinateFactory(), nX, nY));
    }

    public static ImmutablePoint getPointOnLine(List<ImmutablePoint> line, double percentage) {
        Iterator<ImmutablePoint> iter = line.iterator();
        ImmutablePoint point = iter.next();
        double x = point.getX();
        double y = point.getY();
        double length = 0.0;
        while (iter.hasNext()) {
            point = iter.next();
            double x2 = point.getX();
            double y2 = point.getY();
            double dx = x2 - x;
            double dy = y2 - y;
            length += Math.sqrt(dx * dx + dy * dy);
            x = x2;
            y = y2;
        }
        double nX = x;
        double nY = y;
        double nLength = length * percentage;
        iter = line.iterator();
        point = iter.next();
        x = point.getX();
        y = point.getY();
        while (iter.hasNext()) {
            double y2;
            double dy;
            point = iter.next();
            double x2 = point.getX();
            double dx = x2 - x;
            double partlength = Math.sqrt(dx * dx + (dy = (y2 = point.getY()) - y) * dy);
            if (nLength > partlength) {
                nLength -= partlength;
            } else {
                nX = x + dx / partlength * nLength;
                nY = y + dy / partlength * nLength;
                break;
            }
            x = x2;
            y = y2;
        }
        return ImmutableGeoObjectFactory.createImmutablePoint(new Coordinate(point.getCoordinateFactory(), nX, nY));
    }

    public static ImmutablePoint findNearestPoint(ImmutablePoint refPoint, Iterator<ImmutablePoint> pointIterator, Double tolerance) {
        ImmutablePoint point = null;
        double minDist = Double.MAX_VALUE;
        while (pointIterator.hasNext()) {
            ImmutablePoint next = pointIterator.next();
            double dist = refPoint.distance(next);
            if (!(dist < minDist)) continue;
            point = next;
            minDist = dist;
        }
        return tolerance == null || minDist <= tolerance ? point : null;
    }

    public static ImmutablePolygon getConvexHull(Collection<ImmutablePoint> points) throws IllegalPointCountException {
        int pointCount = points.size();
        if (pointCount < 3) {
            throw new IllegalPointCountException(pointCount);
        }
        ImmutablePoint maxX = GeoUtils.getMaxXPoint(points, true);
        ImmutablePoint minX = GeoUtils.getMaxXPoint(points, false);
        if (maxX == null) {
            System.out.println();
        }
        List<ImmutablePoint> list = GeoUtils.quickHull(points, minX, maxX);
        list.addAll(GeoUtils.quickHull(points, maxX, minX));
        return ImmutableGeoObjectFactory.createImmutablePolygon(GeoUtils.filterMultiplePoints(list));
    }

    public static List<ImmutablePoint> filterMultiplePoints(List<ImmutablePoint> points) {
        ArrayList<ImmutablePoint> nPoints = new ArrayList<ImmutablePoint>(points.size());
        Iterator<ImmutablePoint> iter = points.iterator();
        if (iter.hasNext()) {
            ImmutablePoint pred = iter.next();
            nPoints.add(pred);
            while (iter.hasNext()) {
                ImmutablePoint succ = iter.next();
                if (succ.equals(pred)) continue;
                nPoints.add(succ);
                pred = succ;
            }
        }
        return nPoints;
    }

    protected static ImmutablePoint getMaxXPoint(Collection<ImmutablePoint> points, boolean pos) {
        ImmutablePoint max = null;
        double maxX = (pos ? -1.0 : 1.0) * Double.MAX_VALUE;
        for (ImmutablePoint p : points) {
            double x = p.getX();
            if (x == maxX || pos != x > maxX) continue;
            max = p;
            maxX = x;
        }
        return max;
    }

    protected static double calculateDistanceIndicator(ImmutablePoint start, ImmutablePoint end, ImmutablePoint point) {
        double x1 = end.getX() - start.getX();
        double y1 = end.getY() - start.getY();
        double x2 = point.getX() - start.getX();
        double y2 = point.getY() - start.getY();
        return y2 * x1 - x2 * y1;
    }

    protected static Map<ImmutablePoint, Double> getPointDistanceIndicators(ImmutablePoint start, ImmutablePoint end, Collection<ImmutablePoint> points) {
        LinkedHashMap<ImmutablePoint, Double> pointDistanceSet = new LinkedHashMap<ImmutablePoint, Double>();
        for (ImmutablePoint p : points) {
            double distance = GeoUtils.calculateDistanceIndicator(start, end, p);
            if (!(distance > 0.0)) continue;
            pointDistanceSet.put(p, distance);
        }
        return pointDistanceSet;
    }

    protected static ImmutablePoint getPointWithMaximumDistanceFromLine(Map<ImmutablePoint, Double> pointDistanceSet) {
        double maxDistance = 0.0;
        ImmutablePoint maxPoint = null;
        for (Map.Entry<ImmutablePoint, Double> p : pointDistanceSet.entrySet()) {
            if (!(p.getValue() > maxDistance)) continue;
            maxDistance = p.getValue();
            maxPoint = p.getKey();
        }
        return maxPoint;
    }

    protected static List<ImmutablePoint> quickHull(Collection<ImmutablePoint> points, ImmutablePoint start, ImmutablePoint end) {
        LinkedList<ImmutablePoint> result = new LinkedList<ImmutablePoint>();
        Map<ImmutablePoint, Double> pointsLeftOfLine = GeoUtils.getPointDistanceIndicators(start, end, points);
        ImmutablePoint newMaximalPoint = GeoUtils.getPointWithMaximumDistanceFromLine(pointsLeftOfLine);
        if (newMaximalPoint == null) {
            result.add(end);
        } else {
            Set<ImmutablePoint> newPoints = pointsLeftOfLine.keySet();
            result.addAll(GeoUtils.quickHull(newPoints, start, newMaximalPoint));
            result.addAll(GeoUtils.quickHull(newPoints, newMaximalPoint, end));
        }
        return result;
    }

    public static SearchPolygon createSearchPolygon(Coordinate bottomLeft, Coordinate topRight, MarkerMode markerMode, List<Coordinate> tracePoints, CoordinateFactory coordinateFactory, boolean killSelfIntersections) {
        Coordinate bottomLeftCorrect = coordinateFactory.createCoordinate(bottomLeft);
        Coordinate topRightCorrect = coordinateFactory.createCoordinate(topRight);
        double minx0 = 0.0;
        double maxx0 = 0.0;
        double miny0 = 0.0;
        double maxy0 = 0.0;
        double distance0 = 0.0;
        double cx0 = 0.0;
        double cy0 = 0.0;
        ImmutablePolygonKind searchPoly = null;
        switch (markerMode) {
            case RECTANGLE_CROSSES: 
            case RECTANGLE_WITHIN: {
                minx0 = Math.min(bottomLeftCorrect.getX(), topRightCorrect.getX());
                maxx0 = Math.max(bottomLeftCorrect.getX(), topRightCorrect.getX());
                miny0 = Math.min(bottomLeftCorrect.getY(), topRightCorrect.getY());
                maxy0 = Math.max(bottomLeftCorrect.getY(), topRightCorrect.getY());
                ArrayList<ImmutablePoint> envelope = new ArrayList<ImmutablePoint>();
                envelope.add(ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(minx0, miny0)));
                envelope.add(ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(maxx0, miny0)));
                envelope.add(ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(maxx0, maxy0)));
                envelope.add(ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(minx0, maxy0)));
                try {
                    searchPoly = ImmutableGeoObjectFactory.createImmutablePolygon(envelope);
                }
                catch (Exception e) {
                    searchPoly = null;
                    LOGGER.debug("Could not create polygon", e);
                }
                break;
            }
            case CIRCLE_WITHIN: 
            case CIRCLE_CROSSES: {
                cx0 = bottomLeftCorrect.getX();
                cy0 = bottomLeftCorrect.getY();
                distance0 = Math.sqrt(Math.pow(cx0 - topRightCorrect.getX(), 2.0) + Math.pow(cy0 - topRightCorrect.getY(), 2.0));
                minx0 = cx0 - distance0;
                maxx0 = cx0 + distance0;
                miny0 = cy0 - distance0;
                maxy0 = cy0 + distance0;
                break;
            }
            case FREEHAND_WITHIN: 
            case FREEHAND_HALF: {
                minx0 = Math.min(bottomLeftCorrect.getX(), topRightCorrect.getX());
                maxx0 = Math.max(bottomLeftCorrect.getX(), topRightCorrect.getX());
                miny0 = Math.min(bottomLeftCorrect.getY(), topRightCorrect.getY());
                maxy0 = Math.max(bottomLeftCorrect.getY(), topRightCorrect.getY());
                for (Coordinate coordinate : tracePoints) {
                    Coordinate coordinateCorrect = coordinateFactory.createCoordinate(coordinate);
                    minx0 = Math.min(minx0, coordinateCorrect.getX());
                    maxx0 = Math.max(maxx0, coordinateCorrect.getX());
                    miny0 = Math.min(miny0, coordinateCorrect.getY());
                    maxy0 = Math.max(maxy0, coordinateCorrect.getY());
                }
                if (tracePoints.size() <= 2) break;
                ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(tracePoints.size());
                for (Coordinate coordinate : tracePoints) {
                    points.add(ImmutableGeoObjectFactory.createImmutablePoint(coordinate));
                }
                try {
                    if (killSelfIntersections) {
                        SelfIntersectionKiller selfIntersectionKiller = new SelfIntersectionKiller(Collections.singletonList(points));
                        selfIntersectionKiller.start(false);
                        searchPoly = selfIntersectionKiller.getResult();
                        break;
                    }
                    searchPoly = ImmutableGeoObjectFactory.createImmutablePolygon(points);
                }
                catch (Exception exception) {
                    searchPoly = null;
                    LOGGER.debug("Could not create polygon", exception);
                }
                break;
            }
        }
        return new SearchPolygon(searchPoly, minx0, maxx0, miny0, maxy0, distance0, cx0, cy0);
    }

    public static boolean isSelfIntersecting(ImmutableGeoObject immutableGeoObject) {
        if (immutableGeoObject instanceof ImmutableLineString) {
            ImmutableLineString immutableLineString = (ImmutableLineString)immutableGeoObject;
            return GeoUtils.isSelfIntersecting(immutableLineString.getCoordinates(), false);
        }
        if (immutableGeoObject instanceof ImmutablePolygon) {
            ImmutablePolygon polygon = (ImmutablePolygon)immutableGeoObject;
            return GeoUtils.isSelfIntersecting(polygon, false);
        }
        if (immutableGeoObject instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)immutableGeoObject;
            return GeoUtils.isSelfIntersecting(multiPolygon, false);
        }
        return false;
    }

    public static boolean isSelfIntersecting(ImmutablePolygonKind polygonKind, boolean ignoreOnePointTouch) {
        if (polygonKind instanceof ImmutablePolygon) {
            return GeoUtils.isSelfIntersecting((ImmutablePolygon)polygonKind, ignoreOnePointTouch);
        }
        if (polygonKind instanceof ImmutableMultiPolygon) {
            return GeoUtils.isSelfIntersecting((ImmutableMultiPolygon)polygonKind, ignoreOnePointTouch);
        }
        return false;
    }

    public static boolean isSelfIntersecting(ImmutableMultiPolygon multiPolygon, boolean ignoreOnePointTouch) {
        List parts = multiPolygon.getParts();
        for (ImmutablePolygon polygon : parts) {
            if (!GeoUtils.isSelfIntersecting(polygon, ignoreOnePointTouch)) continue;
            return true;
        }
        ListIterator outerIter = parts.listIterator();
        while (outerIter.hasNext()) {
            ImmutableGeoObject intersection;
            ImmutablePolygon polygon;
            polygon = (ImmutablePolygon)outerIter.next();
            if (!outerIter.hasNext()) continue;
            ListIterator innerIter = parts.listIterator(outerIter.nextIndex());
            ImmutablePolygon polygon2 = (ImmutablePolygon)innerIter.next();
            if (!(ignoreOnePointTouch ? (intersection = polygon.intersection(polygon2)) != null && !(intersection instanceof ImmutablePoint) : polygon.intersects(polygon2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelfIntersecting(ImmutablePolygon polygon, boolean ignoreOneTouchPoints) {
        if (GeoUtils.isSelfIntersecting(polygon.getShell().getCoordinates(), true)) {
            return true;
        }
        for (ImmutableLineString immutableLineString : polygon.getHoles()) {
            if (!GeoUtils.isSelfIntersecting(immutableLineString.getCoordinates(), true)) continue;
            return true;
        }
        ImmutableLineString shell = GeoUtils.appendToRingIfNecessary(polygon.getShell());
        ListIterator<ImmutableLineString> outerIter = polygon.getHoles().listIterator();
        while (outerIter.hasNext()) {
            ImmutableGeoObject intersection;
            ImmutableLineString hole = outerIter.next();
            hole = GeoUtils.appendToRingIfNecessary(hole);
            if (ignoreOneTouchPoints ? (intersection = shell.intersection(hole)) != null && !(intersection instanceof ImmutablePoint) : shell.intersects(hole)) {
                return true;
            }
            if (!outerIter.hasNext()) continue;
            ListIterator<ImmutableLineString> innerIter = polygon.getHoles().listIterator(outerIter.nextIndex());
            while (innerIter.hasNext()) {
                ImmutableGeoObject intersection2;
                ImmutableLineString innerHole = innerIter.next();
                if (!(ignoreOneTouchPoints ? (intersection2 = hole.intersection(innerHole)) != null && !(intersection2 instanceof ImmutablePoint) : hole.intersects(innerHole))) continue;
                return true;
            }
        }
        return false;
    }

    public static ImmutableLineString appendToRingIfNecessary(ImmutableLineString lineString) {
        ImmutablePoint last;
        List<ImmutablePoint> coordinates = lineString.getCoordinates();
        ImmutablePoint first = coordinates.get(0);
        if (!first.equals(last = coordinates.get(coordinates.size() - 1))) {
            LinkedList<ImmutablePoint> newPoints = new LinkedList<ImmutablePoint>(coordinates);
            newPoints.add(first);
            return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(newPoints);
        }
        return lineString;
    }

    public static boolean isSelfIntersecting(List<ImmutablePoint> points, boolean checkRing) {
        LinkedList<ImmutablePoint> filteredPoints = new LinkedList<ImmutablePoint>();
        ImmutablePoint p = null;
        for (ImmutablePoint point : points) {
            if (p == null || !p.equals(point)) {
                filteredPoints.add(point);
            }
            p = point;
        }
        if (checkRing && !((ImmutablePoint)filteredPoints.get(0)).equals(p)) {
            filteredPoints.add((ImmutablePoint)filteredPoints.get(0));
        }
        ListIterator<ImmutablePoint> outer = points.listIterator();
        ImmutablePoint outerPred = outer.next();
        while (outer.hasNext()) {
            ImmutablePoint outerSucc = outer.next();
            ImmutableLineString outerLine = ImmutableGeoObjectFactory.createImmutableLineString(outerPred.getCoordinate(), outerSucc.getCoordinate(), new Coordinate[0]);
            int nextIndex = outer.nextIndex();
            if (nextIndex < points.size() - 1) {
                ListIterator<ImmutablePoint> inner = points.listIterator(nextIndex);
                ImmutablePoint innerPred = outerSucc;
                ImmutablePoint innerSucc = inner.next();
                ImmutableLineString innerLine = ImmutableGeoObjectFactory.createImmutableLineString(innerPred.getCoordinate(), innerSucc.getCoordinate(), new Coordinate[0]);
                if (outerLine.covers(innerLine) || innerLine.covers(outerLine)) {
                    return true;
                }
                innerPred = innerSucc;
                while (inner.hasNext()) {
                    innerSucc = inner.next();
                    innerLine = ImmutableGeoObjectFactory.createImmutableLineString(innerPred.getCoordinate(), innerSucc.getCoordinate(), new Coordinate[0]);
                    if (outerLine.crosses(innerLine)) {
                        return true;
                    }
                    innerPred = innerSucc;
                }
            }
            outerPred = outerSucc;
        }
        return false;
    }

    public static ImmutablePolygonKind createImmutableMultiPolygon(Collection<? extends ImmutablePolygonKind> parts) {
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        Iterator<? extends ImmutablePolygonKind> iterator = parts.iterator();
        ImmutableGeoObject result = iterator.next();
        while (iterator.hasNext()) {
            ImmutablePolygonKind geom = iterator.next();
            try {
                result = result.union(geom);
            }
            catch (TopologyException e) {
                ImmutablePolygonKind broken = result instanceof ImmutableGeometryCollection ? ((ImmutableGeometryCollection)result).unionPolygonsToOneMultiPolygon() : (ImmutablePolygonKind)result;
                PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(broken);
                polygonSelfIntersectionKiller.start(false);
                result = polygonSelfIntersectionKiller.getResult();
                polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(geom);
                polygonSelfIntersectionKiller.start(false);
                geom = polygonSelfIntersectionKiller.getResult();
                result = (ImmutablePolygonKind)result.union(geom);
            }
        }
        if (result instanceof ImmutableGeometryCollection) {
            return ((ImmutableGeometryCollection)result).unionPolygonsToOneMultiPolygon();
        }
        if (result instanceof ImmutablePolygonKind) {
            return (ImmutablePolygonKind)result;
        }
        throw new RuntimeException();
    }

    public static double getSphericalPolygonArea(ImmutablePolygonKind polygon) {
        ImmutablePolygonKind wgsPolygon = (ImmutablePolygonKind)polygon.getTransformed(Wgs84Factory.INSTANCE);
        if (wgsPolygon instanceof ImmutablePolygon) {
            ImmutablePolygon immutablePolygon = (ImmutablePolygon)wgsPolygon;
            return GeoUtils.getSphericalPolygonArea(immutablePolygon);
        }
        if (wgsPolygon instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon immutableMultiPolygon = (ImmutableMultiPolygon)wgsPolygon;
            return GeoUtils.getSphericalPolygonArea(immutableMultiPolygon);
        }
        return 0.0;
    }

    public static double getSphericalPolygonArea(ImmutableMultiPolygon polygon) {
        double sum = 0.0;
        for (ImmutablePolygon immutablePolygon : polygon.getParts()) {
            sum += GeoUtils.getSphericalPolygonArea(immutablePolygon);
        }
        return sum;
    }

    public static double getSphericalPolygonArea(ImmutablePolygon polygon) {
        double sum = GeoUtils.getSphericalPolygonArea(polygon.getShell().getCoordinates());
        for (ImmutableLineString hole : polygon.getHoles()) {
            sum -= GeoUtils.getSphericalPolygonArea(hole.getCoordinates());
        }
        return sum;
    }

    public static double getSphericalPolygonArea(List<ImmutablePoint> points) {
        double lam1 = 0.0;
        double lam2 = 0.0;
        double beta1 = 0.0;
        double beta2 = 0.0;
        double cosB1 = 0.0;
        double cosB2 = 0.0;
        double hav = 0.0;
        double sum = 0.0;
        ArrayList<ImmutablePoint> list = new ArrayList<ImmutablePoint>(points.size());
        ImmutablePoint first = null;
        for (ImmutablePoint point : points) {
            ImmutablePoint transformed = (ImmutablePoint)point.getTransformed(Wgs84Factory.INSTANCE);
            if (first == null) {
                first = transformed;
            }
            list.add(transformed);
        }
        if (list.size() > 1 && first.equals(list.get(list.size() - 1))) {
            list.remove(list.size() - 1);
        }
        int count = list.size();
        for (int j = 0; j < count; ++j) {
            if (j == 0) {
                ImmutablePoint point1 = (ImmutablePoint)list.get(j);
                lam1 = GeoUtils.deg2rad(point1.getX());
                beta1 = GeoUtils.deg2rad(point1.getY());
                ImmutablePoint point2 = (ImmutablePoint)list.get(j + 1);
                lam2 = GeoUtils.deg2rad(point2.getX());
                beta2 = GeoUtils.deg2rad(point2.getY());
                cosB1 = Math.cos(beta1);
                cosB2 = Math.cos(beta2);
            } else {
                int k = (j + 1) % count;
                lam1 = lam2;
                beta1 = beta2;
                ImmutablePoint point = (ImmutablePoint)list.get(k);
                lam2 = GeoUtils.deg2rad(point.getX());
                beta2 = GeoUtils.deg2rad(point.getY());
                cosB1 = cosB2;
                cosB2 = Math.cos(beta2);
            }
            if (lam1 == lam2) continue;
            hav = GeoUtils.haversine(beta2 - beta1) + cosB1 * cosB2 * GeoUtils.haversine(lam2 - lam1);
            double a = 2.0 * Math.asin(Math.sqrt(hav));
            double b = 1.5707963267948966 - beta2;
            double c = 1.5707963267948966 - beta1;
            double s = 0.5 * (a + b + c);
            double t = Math.tan(s / 2.0) * Math.tan((s - a) / 2.0) * Math.tan((s - b) / 2.0) * Math.tan((s - c) / 2.0);
            double excess = Math.abs(4.0 * Math.atan(Math.sqrt(Math.abs(t))));
            if (lam2 < lam1) {
                excess = -excess;
            }
            sum += excess;
        }
        return Math.abs(sum) * 6371000.0 * 6371000.0;
    }

    private static double haversine(double d) {
        return (1.0 - Math.cos(d)) / 2.0;
    }

    private static double deg2rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    public static ImmutablePoint cutStraights2D(ImmutablePoint straight1Point1, ImmutablePoint straight1Point2, ImmutablePoint straight2Point1, ImmutablePoint straight2Point2) {
        Tripel<ImmutablePoint, Double, Double> tripel = GeoUtils.cutStraights2DInternal(straight1Point1, straight1Point2, straight2Point1, straight2Point2);
        return tripel == null ? null : tripel.getElement1();
    }

    private static Tripel<ImmutablePoint, Double, Double> cutStraights2DInternal(ImmutablePoint straight1Point1, ImmutablePoint straight1Point2, ImmutablePoint straight2Point1, ImmutablePoint straight2Point2) {
        double sx1 = straight1Point1.getX();
        double tx1 = straight1Point2.getX() - sx1;
        double sy1 = straight1Point1.getY();
        double ty1 = straight1Point2.getY() - sy1;
        double sx2 = straight2Point1.getX();
        double tx2 = straight2Point2.getX() - sx2;
        double sy2 = straight2Point1.getY();
        double ty2 = straight2Point2.getY() - sy2;
        double d = ty2 * tx1 - tx2 * ty1;
        if (d == 0.0) {
            return null;
        }
        double v2 = (sy1 * tx1 - sx2 * ty1 - sx1 * ty1 - sy2 * tx1) / d;
        double v1 = (sx2 + v2 * tx2 - sx1) / tx1;
        double x = sx2 - tx2 * v2;
        double y = sy2 - ty2 * v2;
        return new Tripel<ImmutablePoint, Double, Double>(ImmutableGeoObjectFactory.createImmutablePoint(straight1Point1.getCoordinateFactory().createCoordinate(x, y)), v1, v2);
    }

    public static ImmutablePolygonKind stretchBlocks(ImmutablePolygonKind polygon, double dist, Map<ImmutablePolygon, ImmutablePolygonKind> streched) {
        if (polygon instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)polygon;
            ImmutablePolygonKind result = null;
            for (ImmutablePolygon sPolygon : multiPolygon.getParts()) {
                ImmutablePolygonKind stretch = null;
                if (streched != null) {
                    stretch = streched.get(sPolygon);
                }
                if (stretch == null) {
                    stretch = GeoUtils.stretchBlocks(sPolygon, dist);
                    if (streched != null) {
                        streched.put(sPolygon, stretch);
                    }
                }
                if (stretch == null) continue;
                if (result == null) {
                    result = stretch;
                    continue;
                }
                result = (ImmutablePolygonKind)result.union(stretch);
            }
            return result;
        }
        if (polygon instanceof ImmutablePolygon) {
            ImmutablePolygon sPolygon = (ImmutablePolygon)polygon;
            ImmutablePolygonKind stretch = null;
            if (streched != null) {
                stretch = streched.get(sPolygon);
            }
            if (stretch == null) {
                stretch = GeoUtils.stretchBlocks(sPolygon, dist);
                if (streched != null) {
                    streched.put(sPolygon, stretch);
                }
            }
            return stretch;
        }
        return polygon;
    }

    private static ImmutablePolygonKind stretchBlocks(ImmutablePolygon polygon, double dist) {
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>(polygon.getCoordinates());
        int size = points.size();
        if (((ImmutablePoint)points.get(0)).equals(points.get(size - 1))) {
            points.remove(size - 1);
        }
        points.add((ImmutablePoint)points.get(0));
        points.add((ImmutablePoint)points.get(1));
        points.add((ImmutablePoint)points.get(2));
        ListIterator iter = points.listIterator();
        ImmutablePoint p1 = (ImmutablePoint)iter.next();
        ImmutablePoint p2 = (ImmutablePoint)iter.next();
        ImmutablePoint p3 = (ImmutablePoint)iter.next();
        ImmutablePolygonKind result = null;
        while (iter.hasNext()) {
            Coordinate middle2;
            double tDist2;
            ImmutablePoint p4 = (ImmutablePoint)iter.next();
            Coordinate middle1 = GeoUtils.getMiddleInAngel(p1, p2, p3);
            double tDist1 = GeoUtils.getDistanceInMeter(middle1, p2.getCoordinate());
            if (tDist1 == 0.0) {
                double ny = (p3.getX() - p2.getX()) * -1.0;
                double nx = p3.getY() - p2.getY();
                middle1 = middle1.getFactory().createCoordinate(p2.getX() + nx, p2.getY() + ny);
                tDist1 = GeoUtils.getDistanceInMeter(middle1, p2.getCoordinate());
            }
            if ((tDist2 = GeoUtils.getDistanceInMeter(middle2 = GeoUtils.getMiddleInAngel(p2, p3, p4), p3.getCoordinate())) == 0.0) {
                double ny = (p3.getX() - p2.getX()) * -1.0;
                double nx = p3.getY() - p2.getY();
                middle2 = middle2.getFactory().createCoordinate(p3.getX() + nx, p3.getY() + ny);
                tDist2 = GeoUtils.getDistanceInMeter(middle2, p3.getCoordinate());
            }
            Coordinate distPointOut1 = GeoUtils.getDistPoint(middle1, p2, dist, tDist1, false);
            Coordinate distPointIn1 = GeoUtils.getDistPoint(middle1, p2, dist, tDist1, true);
            Coordinate distPointOut2 = GeoUtils.getDistPoint(middle2, p3, dist, tDist2, false);
            Coordinate distPointIn2 = GeoUtils.getDistPoint(middle2, p3, dist, tDist2, true);
            ImmutablePolygon block = null;
            try {
                block = GeoUtils.getConvexHull(Arrays.asList(ImmutableGeoObjectFactory.createImmutablePoint(distPointOut1), ImmutableGeoObjectFactory.createImmutablePoint(distPointOut2), ImmutableGeoObjectFactory.createImmutablePoint(distPointIn1), ImmutableGeoObjectFactory.createImmutablePoint(distPointIn2)));
            }
            catch (IllegalPointCountException e) {
                LOGGER.warn("Could not create strech block for coords " + distPointOut1 + " - " + distPointIn1 + " - " + distPointOut2 + " - " + distPointIn2);
            }
            if (block != null) {
                if (result == null) {
                    result = block;
                } else {
                    try {
                        ImmutableGeoObject union = result.union(block);
                        if (union instanceof ImmutablePolygonKind) {
                            result = (ImmutablePolygonKind)union;
                        } else {
                            LOGGER.warn("Adding a block when stretching, did not create a polygon kind");
                        }
                    }
                    catch (TopologyException ex) {
                        PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(result);
                        polygonSelfIntersectionKiller.start(false);
                        result = polygonSelfIntersectionKiller.getResult();
                        try {
                            ImmutableGeoObject union = result.union(block);
                            result = (ImmutablePolygonKind)union;
                            if (union instanceof ImmutablePolygonKind) {
                                result = (ImmutablePolygonKind)union;
                            } else {
                                LOGGER.warn("Adding a block when stretching, did not create a polygon kind");
                            }
                        }
                        catch (TopologyException ex1) {
                            LOGGER.warn("Could not union");
                        }
                    }
                }
            }
            p1 = p2;
            p2 = p3;
            p3 = p4;
        }
        if (result == null) {
            return null;
        }
        if (GeoUtils.isSelfIntersecting(result)) {
            PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(result);
            polygonSelfIntersectionKiller.start(false);
            result = polygonSelfIntersectionKiller.getResult();
        }
        AbstractImmutableValidGeoObject resultPolygon = null;
        try {
            if (result instanceof ImmutablePolygon) {
                resultPolygon = ImmutableGeoObjectFactory.createImmutablePolygon(((ImmutablePolygon)result).getShell().getCoordinates());
            } else if (result instanceof ImmutableMultiPolygon) {
                ImmutableMultiPolygon multi = (ImmutableMultiPolygon)result;
                List parts = multi.getParts();
                ArrayList<ImmutablePolygon> nParts = new ArrayList<ImmutablePolygon>(parts.size());
                for (ImmutablePolygon part : parts) {
                    nParts.add(ImmutableGeoObjectFactory.createImmutablePolygon(part.getShell().getCoordinates()));
                }
                resultPolygon = ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(multi.getCoordinateFactory(), nParts);
            }
        }
        catch (IllegalPointCountException e) {
            return null;
        }
        return resultPolygon;
    }

    private static Coordinate getDistPoint(Coordinate middle, ImmutablePoint point, double dist, double tDist, boolean minus) {
        double pointX = point.getX();
        double pointY = point.getY();
        double vx = middle.getX() - pointX;
        double vy = middle.getY() - pointY;
        if (tDist == 0.0) {
            tDist = 1.0E-12;
        }
        double nvx = vx / tDist;
        double nvy = vy / tDist;
        double lvx = nvx * dist;
        double lvy = nvy * dist;
        if (minus) {
            lvx *= -1.0;
            lvy *= -1.0;
        }
        Coordinate s = point.getCoordinateFactory().createCoordinate(pointX + lvx, pointY + lvy);
        return s;
    }

    public static ImmutablePolygonKind stretchAngleSym(ImmutablePolygonKind polygon, double dist) {
        if (polygon instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)polygon;
            ImmutablePolygonKind result = null;
            for (ImmutablePolygon sPolygon : multiPolygon.getParts()) {
                ImmutablePolygonKind stretch = GeoUtils.stretchAngleSym(sPolygon, dist);
                if (stretch == null) continue;
                if (result == null) {
                    result = stretch;
                    continue;
                }
                result = (ImmutablePolygonKind)result.union(stretch);
            }
            return result;
        }
        if (polygon instanceof ImmutablePolygon) {
            return GeoUtils.stretchAngleSym((ImmutablePolygon)polygon, dist);
        }
        return polygon;
    }

    private static ImmutablePolygonKind stretchAngleSym(ImmutablePolygon polygon, double dist) {
        CoordinateFactory coordinateFactory = polygon.getCoordinateFactory();
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>(polygon.getCoordinates());
        int size = points.size();
        if (((ImmutablePoint)points.get(0)).equals(points.get(size - 1))) {
            points.remove(size - 1);
        }
        points.add((ImmutablePoint)points.get(0));
        points.add((ImmutablePoint)points.get(1));
        Iterator iter = points.iterator();
        ImmutablePoint pred = (ImmutablePoint)iter.next();
        ImmutablePoint current = (ImmutablePoint)iter.next();
        LinkedList<ImmutablePoint> result = new LinkedList<ImmutablePoint>();
        while (iter.hasNext()) {
            ImmutablePoint succ = (ImmutablePoint)iter.next();
            double angle = ComputeTrigonometrics.angleBetween(current.getX(), current.getY(), pred.getX(), pred.getY(), succ.getX(), succ.getY());
            Coordinate middle = GeoUtils.getMiddleInAngel(pred, current, succ);
            double tDist = ComputeTrigonometrics.getSphericalDistance(middle, current.getCoordinate());
            double vx = middle.getX() - current.getX();
            double vy = middle.getY() - current.getY();
            double nvx = vx / tDist;
            double nvy = vy / tDist;
            double f = 1.0;
            boolean clockwise = GeoUtils.isClockwise(polygon);
            if (clockwise && angle <= Math.PI || !clockwise && angle > Math.PI) {
                f = -1.0;
            }
            double lvx = nvx * dist * f;
            double lvy = nvy * dist * f;
            Coordinate s = coordinateFactory.createCoordinate(current.getX() + lvx, current.getY() + lvy);
            ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(s);
            if (!polygon.contains(point)) {
                result.add(point);
            }
            pred = current;
            current = succ;
        }
        SelfIntersectionKiller selfIntersectionKiller = new SelfIntersectionKiller(Collections.singletonList(result));
        selfIntersectionKiller.start(false);
        return selfIntersectionKiller.getResult();
    }

    private static Coordinate getMiddleInAngel(ImmutablePoint pred, ImmutablePoint current, ImmutablePoint succ) {
        double predX = pred.getX();
        double currentX = current.getX();
        double predY = pred.getY();
        double tx1 = predX - currentX;
        double currentY = current.getY();
        double succX = succ.getX();
        double succY = succ.getY();
        double ty1 = predY - currentY;
        double length1 = Math.sqrt(Math.pow(tx1, 2.0) + Math.pow(ty1, 2.0));
        double tx2 = succX - currentX;
        double ty2 = succY - currentY;
        double length2 = Math.sqrt(Math.pow(tx2, 2.0) + Math.pow(ty2, 2.0));
        double x1 = currentX + (tx1 /= (length1 *= 0.001));
        double y1 = currentY + (ty1 /= length1);
        double x2 = currentX + (tx2 /= (length2 *= 0.001));
        double y2 = currentY + (ty2 /= length2);
        double mx = (x1 + x2) / 2.0;
        double my = (y1 + y2) / 2.0;
        Coordinate middle = current.getCoordinateFactory().createCoordinate(mx, my);
        return middle;
    }

    public static ImmutablePolygonKind stretchFromCentroid(ImmutablePolygonKind polygon, double dist) {
        if (polygon instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)polygon;
            ImmutablePolygonKind result = null;
            for (ImmutablePolygon sPolygon : multiPolygon.getParts()) {
                ImmutablePolygonKind stretch = GeoUtils.stretchFromCentroid(sPolygon, dist);
                if (stretch == null) continue;
                if (result == null) {
                    result = stretch;
                    continue;
                }
                result = (ImmutablePolygonKind)result.union(stretch);
            }
            return result;
        }
        if (polygon instanceof ImmutablePolygon) {
            return GeoUtils.stretchFromCentroid((ImmutablePolygon)polygon, dist);
        }
        return polygon;
    }

    private static ImmutablePolygonKind stretchFromCentroid(ImmutablePolygon polygon, double dist) {
        ImmutablePoint centroid = polygon.getCentroid();
        List<ImmutablePoint> coordinates = polygon.getShell().getCoordinates();
        double cx = centroid.getX();
        double cy = centroid.getY();
        Coordinate cCoord = centroid.getCoordinate();
        int size = coordinates.size();
        ArrayList<ImmutablePoint> loop1 = new ArrayList<ImmutablePoint>(size);
        CoordinateFactory coordinateFactory = polygon.getCoordinateFactory();
        for (ImmutablePoint coord : coordinates) {
            double tDist = ComputeTrigonometrics.getSphericalDistance(cCoord, coord.getCoordinate());
            double x = coord.getX();
            double vx = x - cx;
            double y = coord.getY();
            double vy = y - cy;
            double nvx = vx / tDist;
            double nvy = vy / tDist;
            double lvx = nvx * dist;
            double lvy = nvy * dist;
            Coordinate s1 = coordinateFactory.createCoordinate(x + lvx, y + lvy);
            loop1.add(ImmutableGeoObjectFactory.createImmutablePoint(s1));
        }
        ImmutablePolygonKind rPolygon1 = null;
        SelfIntersectionKiller selfIntersectionKiller = new SelfIntersectionKiller(Collections.singletonList(loop1));
        selfIntersectionKiller.start(false);
        rPolygon1 = selfIntersectionKiller.getResult();
        if (rPolygon1 == null) {
            rPolygon1 = polygon;
        }
        return rPolygon1;
    }

    public static ImmutablePolygonKind killSelfIntersections(ImmutablePolygonKind geom) {
        PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(geom);
        polygonSelfIntersectionKiller.start(false);
        return polygonSelfIntersectionKiller.getResult();
    }

    public static boolean isGeomInRectangle(double left, double right, double top, double bottom, ImmutableGeoObject immutableGeoObject) {
        double maxX = immutableGeoObject.getMaxX();
        double minX = immutableGeoObject.getMinX();
        double maxY = immutableGeoObject.getMaxY();
        double minY = immutableGeoObject.getMinY();
        return left >= minX && left <= maxX && top <= maxY && top >= minY || left >= minX && left <= maxX && bottom <= maxY && bottom >= minY || right >= minX && right <= maxX && top <= maxY && top >= minY || right >= minX && right <= maxX && bottom <= maxY && bottom >= minY || left <= minX && right >= minX && top >= maxY && bottom <= maxY || left <= minX && right >= minX && top >= minY && bottom <= minY || left <= maxX && right >= maxX && top >= maxY && bottom <= maxY || left <= maxX && right >= maxX && top >= minY && bottom <= minY || right <= minX && right <= maxX && left >= minX && left >= maxX && bottom >= maxY && bottom >= minY && top <= maxY && top <= minY || right >= minX && right >= maxX && left <= minX && left <= maxX && bottom <= maxY && bottom <= minY && top >= maxY && top >= minY || left >= minX && right <= maxX && top >= maxY && bottom <= minY || left <= minX && right >= maxX && top <= maxY && bottom >= minY;
    }

    public static AbstractImmutableGeoObject getLineString(ImmutablePoint point1, ImmutablePoint point2) {
        AbstractImmutableValidGeoObject lineStringOrPoint = null;
        if (point1 == null || point2 == null) {
            lineStringOrPoint = null;
        } else if ((point1 = (ImmutablePoint)point1.getTransformed(point2.getCoordinateFactory())).getCoordinate().equals(point2.getCoordinate())) {
            lineStringOrPoint = point1;
        } else {
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>(2);
            coords.add(point1.getCoordinate());
            coords.add(point2.getCoordinate());
            lineStringOrPoint = ImmutableGeoObjectFactory.createImmutableLineString(coords);
        }
        return lineStringOrPoint;
    }

    public static Set<Coordinate> getAreaRectangle(Collection<ImmutablePoint> points) {
        if (points == null || points.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Coordinate> areaRectangle = new HashSet<Coordinate>(2);
        Coordinate startPoint = points.iterator().next().getCoordinate();
        CoordinateFactory coordinateFactory = startPoint.getFactory();
        double maxX = startPoint.getX();
        double maxY = startPoint.getY();
        double minX = startPoint.getX();
        double minY = startPoint.getY();
        for (ImmutablePoint point : points) {
            if (point == null) continue;
            if ((point = (ImmutablePoint)point.getTransformed(coordinateFactory)).getX() < minX) {
                minX = point.getX();
            } else if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
                continue;
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        areaRectangle.add(coordinateFactory.createCoordinate(minX, minY));
        areaRectangle.add(coordinateFactory.createCoordinate(maxX, maxY));
        return areaRectangle;
    }

    public static Tupel<ImmutablePoint, ImmutablePoint> getBoundaryOfNavigatorPanel(NavigatorPanel navigatorPanel) {
        Point2D.Double topRight = navigatorPanel.getRealBoundaryTopRight();
        Point2D.Double bottomLeft = navigatorPanel.getRealBoundaryBottomLeft();
        if (topRight == null || bottomLeft == null || navigatorPanel.getCoordinateFactory() == null) {
            return null;
        }
        Coordinate topLeftCoordinate = navigatorPanel.getCoordinateFactory().createCoordinate(bottomLeft.x, topRight.y);
        Coordinate bottomRightCoordinate = navigatorPanel.getCoordinateFactory().createCoordinate(topRight.x, bottomLeft.y);
        ImmutablePoint topLeft = ImmutableGeoObjectFactory.createImmutablePoint(topLeftCoordinate);
        ImmutablePoint bottomRight = ImmutableGeoObjectFactory.createImmutablePoint(bottomRightCoordinate);
        return new Tupel<ImmutablePoint, ImmutablePoint>(topLeft, bottomRight);
    }

    public static ImmutableEnvelope getEnvelope(ImmutablePoint point, double distance) {
        Coordinate c = Wgs84Factory.INSTANCE.createCoordinate(point.getCoordinate());
        double dx = GeoUtils.getLngDrift(c.getX(), c.getY(), distance);
        double dy = GeoUtils.getLatDrift(c.getX(), c.getY(), distance);
        return new ImmutableEnvelope(c.getX() - dx, c.getX() + dx, c.getY() - dy, c.getY() + dy, c.getFactory());
    }

    public static double getDistanceInMeter(Coordinate c1, Coordinate c2) {
        Coordinate newC1 = Wgs84Factory.INSTANCE.createCoordinate(c1);
        Coordinate newC2 = Wgs84Factory.INSTANCE.createCoordinate(c2);
        double distance = GeoUtils.getDistanceInMeter(newC1.getX(), newC1.getY(), newC2.getX(), newC2.getY());
        return Double.isNaN(distance) ? 0.0 : distance;
    }

    public static double getDistanceInMeter(ImmutablePoint p1, ImmutablePoint p2) {
        if (p1 == null || p2 == null) {
            return Double.MAX_VALUE;
        }
        return GeoUtils.getDistanceInMeter(p1.getCoordinate(), p2.getCoordinate());
    }

    public static double getDistanceInMeter(ImmutableLineString lineString, ImmutablePoint point) {
        ImmutableLineString immutableLineString = (ImmutableLineString)lineString.getTransformed(GeoDecimal100Factory.INSTANCE);
        ImmutablePoint immutablePoint = (ImmutablePoint)point.getTransformed(GeoDecimal100Factory.INSTANCE);
        ImmutablePoint basePoint = immutableLineString.getBasePoint(immutablePoint, null);
        return GeoUtils.getDistanceInMeter(immutablePoint.getCoordinate(), basePoint.getCoordinate());
    }

    public static double getDistanceInMeter(ImmutablePolygonKind polygonKind, ImmutablePoint point) {
        if (polygonKind instanceof ImmutablePolygon) {
            ImmutablePolygon polygon = (ImmutablePolygon)polygonKind;
            if (polygon.contains(point)) {
                return 0.0;
            }
            double min = GeoUtils.getDistanceInMeter(polygon.getShell(), point);
            for (ImmutableLineString hole : polygon.getHoles()) {
                double d = GeoUtils.getDistanceInMeter(hole, point);
                if (!(d < min)) continue;
                min = d;
            }
            return min;
        }
        ImmutableMultiPolygon polygon = (ImmutableMultiPolygon)polygonKind;
        Double min = null;
        for (ImmutablePolygon sP : polygon.getParts()) {
            double d = GeoUtils.getDistanceInMeter(sP, point);
            if (min != null && !(d < min)) continue;
            min = d;
            if (d != 0.0) continue;
            break;
        }
        return min == null ? Double.MAX_VALUE : min;
    }

    public static double getDistanceInMeter(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = GeoUtils.deg2rad(lat1);
        double radLat2 = GeoUtils.deg2rad(lat2);
        double dy = radLat1 - radLat2;
        double dx = GeoUtils.deg2rad(lon1) - GeoUtils.deg2rad(lon2);
        double r = Math.asin(Math.sqrt(Math.pow(Math.sin(dy / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(dx / 2.0), 2.0)));
        return r * 2.0 * 6371000.0;
    }

    private static double getLngDrift(double lng1, double lat1, double distance) {
        double r = Math.pow(Math.sin(distance / 6371000.0 / 2.0), 2.0);
        double radLat1 = GeoUtils.deg2rad(lat1);
        double lngDrift = Math.asin(Math.sqrt(r / Math.cos(radLat1))) * 2.0;
        return GeoUtils.rad2deg(lngDrift);
    }

    private static double getLatDrift(double lng1, double lat1, double distance) {
        double r = Math.pow(Math.sin(distance / 6371000.0 / 2.0), 2.0);
        double latDrift = Math.asin(Math.sqrt(r)) * 2.0;
        return GeoUtils.rad2deg(latDrift);
    }

    private static double rad2deg(double angle) {
        return angle * 180.0 / Math.PI;
    }

    public static ImmutablePoint getPointOnLineString(ImmutableLineString lineString, double distance) {
        double walkedDist = 0.0;
        Iterator<ImmutablePoint> iter = lineString.getCoordinates().iterator();
        ImmutablePoint pred = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            double nextDist = pred.distance(succ);
            double tWalkedDist = walkedDist + nextDist;
            if (tWalkedDist >= distance) {
                double subDistance = distance - walkedDist;
                double pX = pred.getX();
                double py = pred.getY();
                double sx = succ.getX();
                double sy = succ.getY();
                double tx = sx - pX;
                double ty = sy - py;
                double length = Math.sqrt(Math.pow(tx, 2.0) + Math.pow(ty, 2.0));
                if (length != 0.0) {
                    tx /= length;
                    ty /= length;
                    tx *= subDistance;
                    ty *= subDistance;
                } else {
                    tx = 0.0;
                    ty = 0.0;
                }
                return ImmutableGeoObjectFactory.createImmutablePoint(lineString.getCoordinateFactory().createCoordinate(pX + tx, py + ty));
            }
            walkedDist = tWalkedDist;
            pred = succ;
        }
        return null;
    }

    public static ImmutablePoint getNearestPoint(ImmutablePolygonKind polygon, ImmutablePoint point) {
        ImmutablePoint nearest;
        block7: {
            double distance;
            block6: {
                polygon = (ImmutablePolygonKind)polygon.getTransformed(GeoDecimal100Factory.INSTANCE);
                point = (ImmutablePoint)point.getTransformed(GeoDecimal100Factory.INSTANCE);
                nearest = null;
                if (!(polygon instanceof ImmutableMultiPolygon)) break block6;
                ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)polygon;
                Double distance2 = null;
                for (ImmutablePolygon subPolygon : multiPolygon.getParts()) {
                    ImmutablePoint sNearest = GeoUtils.getNearestPoint(subPolygon, point);
                    if (nearest == null) {
                        nearest = sNearest;
                        distance2 = point.distance(nearest);
                        continue;
                    }
                    double sDistance = point.distance(sNearest);
                    if (!(sDistance < distance2)) continue;
                    distance2 = sDistance;
                    nearest = sNearest;
                }
                break block7;
            }
            if (!(polygon instanceof ImmutablePolygon)) break block7;
            ImmutablePolygon sPolygon = (ImmutablePolygon)polygon;
            if (sPolygon.contains(point)) {
                return point;
            }
            nearest = GeoUtils.getNearestPoint(sPolygon.getShell(), point);
            try {
                distance = point.distance(nearest);
            }
            catch (Exception ex) {
                return nearest;
            }
            for (ImmutableLineString hole : sPolygon.getHoles()) {
                ImmutablePoint sNearest = GeoUtils.getNearestPoint(hole, point);
                double sDistance = point.distance(sNearest);
                if (!(sDistance < distance)) continue;
                distance = sDistance;
                nearest = sNearest;
            }
        }
        return nearest;
    }

    private static ImmutablePoint getNearestPoint(ImmutableLineString line, ImmutablePoint point) {
        ArrayList<ImmutablePoint> coordinates = new ArrayList<ImmutablePoint>(line.getCoordinates());
        if (((ImmutablePoint)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
            coordinates.remove(coordinates.size() - 1);
        }
        coordinates.add((ImmutablePoint)coordinates.get(0));
        ImmutablePoint nearest = null;
        double bestDist = Double.MAX_VALUE;
        Iterator iter = coordinates.iterator();
        ImmutablePoint pred = (ImmutablePoint)iter.next();
        while (iter.hasNext()) {
            double distPred;
            double ty;
            ImmutablePoint succ = (ImmutablePoint)iter.next();
            double sx = pred.getX();
            double tx = succ.getX() - sx;
            double sy = pred.getY();
            double nx = ty = succ.getY() - sy;
            double ny = -tx;
            double px = point.getX();
            double py = point.getY();
            double t = (ny * sx - px * ny - nx * sy + py * nx) / (nx * ty - ny * tx);
            ImmutablePoint cut = null;
            double distCut = 0.0;
            if (t > 0.0 && t < 1.0) {
                cut = ImmutableGeoObjectFactory.createImmutablePoint(point.getCoordinateFactory().createCoordinate(sx + tx * t, sy + ty * t));
                distCut = point.distance(cut);
            }
            double distSucc = point.distance(succ);
            if (cut == null || distSucc < distCut) {
                cut = succ;
                distCut = distSucc;
            }
            if ((distPred = point.distance(pred)) < distCut) {
                cut = pred;
                distCut = distPred;
            }
            if (distCut < bestDist) {
                nearest = cut;
                bestDist = distCut;
            }
            pred = succ;
        }
        return nearest;
    }

    public static Collection<ImmutablePoint> findCenterPointInPolygonKind(ImmutablePolygonKind polygonKind, boolean ignoreErrors) {
        if (polygonKind instanceof ImmutablePolygon) {
            ImmutablePoint point;
            try {
                point = GeoUtils.findCenterPointInPolygon((ImmutablePolygon)polygonKind);
            }
            catch (RuntimeException ex) {
                if (ignoreErrors) {
                    return Collections.emptyList();
                }
                throw ex;
            }
            return Collections.singletonList(point);
        }
        if (polygonKind instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multi = (ImmutableMultiPolygon)polygonKind;
            List parts = multi.getParts();
            ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(parts.size());
            for (ImmutablePolygon polygon : parts) {
                try {
                    ImmutablePoint point = GeoUtils.findCenterPointInPolygon(polygon);
                    points.add(point);
                }
                catch (Exception ex) {
                    if (ignoreErrors) continue;
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
            return points;
        }
        return Collections.emptyList();
    }

    private static ImmutablePoint findCenterPointInPolygon(ImmutablePolygon polygon) {
        ImmutableGeoObject intersection;
        ImmutableLineString lineString;
        ImmutablePoint centroid = polygon.getCentroid();
        if (polygon.contains(centroid)) {
            return centroid;
        }
        ImmutablePoint nearest = GeoUtils.getNearestPoint(polygon, centroid);
        if (nearest.equals(centroid)) {
            return centroid;
        }
        centroid = (ImmutablePoint)centroid.getTransformed(GeoDecimal100Factory.INSTANCE);
        nearest = (ImmutablePoint)nearest.getTransformed(GeoDecimal100Factory.INSTANCE);
        double nx = nearest.getX();
        double ny = nearest.getY();
        double tx = nx - centroid.getX();
        double ty = ny - centroid.getY();
        ImmutableEnvelope envelope = polygon.getEnvelope().getTransformed(GeoDecimal100Factory.INSTANCE);
        double length = Math.sqrt(Math.pow(envelope.getMaxX() - envelope.getMinX(), 2.0) + Math.pow(envelope.getMaxY() - envelope.getMinY(), 2.0));
        ImmutablePoint end = ImmutableGeoObjectFactory.createImmutablePoint(GeoDecimal100Factory.INSTANCE.createCoordinate(nx + (tx *= length), ny + (ty *= length)));
        try {
            lineString = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(centroid, end, new ImmutablePoint[0]);
        }
        catch (Exception ex) {
            return nearest;
        }
        try {
            intersection = polygon.intersection(lineString);
        }
        catch (Exception ex) {
            return nearest;
        }
        List<ImmutableLineString> cuts = null;
        if (intersection instanceof ImmutableLineString) {
            cuts = Collections.singletonList((ImmutableLineString)intersection);
        } else if (intersection instanceof ImmutableMultiLineString) {
            ImmutableMultiLineString multi = (ImmutableMultiLineString)intersection;
            cuts = multi.getParts();
        } else if (intersection instanceof ImmutableGeometryCollection) {
            ImmutableGeometryCollection collection = (ImmutableGeometryCollection)intersection;
            cuts = new LinkedList();
            for (ImmutableGeoObject object : collection.getParts()) {
                if (object instanceof ImmutableLineString) {
                    cuts.add((ImmutableLineString)object);
                    continue;
                }
                if (!(object instanceof ImmutableMultiLineString)) continue;
                ImmutableMultiLineString multi = (ImmutableMultiLineString)object;
                cuts.addAll(multi.getParts());
            }
        }
        if (cuts == null || cuts.isEmpty()) {
            return (ImmutablePoint)nearest.getTransformed(polygon.getCoordinateFactory());
        }
        int cutCount = cuts.size();
        int middle = cutCount / 2;
        if (cutCount % 2 == 0) {
            --middle;
        }
        if (cutCount > 1) {
            final ImmutablePoint fNearest = nearest;
            Collections.sort(cuts, new Comparator<ImmutableLineString>(){

                @Override
                public int compare(ImmutableLineString o1, ImmutableLineString o2) {
                    double dist1 = o1.getStartPoint().distance(fNearest);
                    double dist2 = o2.getStartPoint().distance(fNearest);
                    return Double.compare(dist1, dist2);
                }
            });
        }
        return (ImmutablePoint)cuts.get(middle).getCentroid().getTransformed(polygon.getCoordinateFactory());
    }

    public static double getEuklidDistance(Coordinate c1, Coordinate c2, CoordinateFactory coordinateFactory) {
        Coordinate t1 = coordinateFactory.createCoordinate(c1);
        Coordinate t2 = coordinateFactory.createCoordinate(c2);
        double vx = t2.getX() - t1.getX();
        double vy = t2.getY() - t1.getY();
        return Math.sqrt(vx * vx + vy * vy);
    }

    public static boolean isNullCoordinate(Coordinate coordinate) {
        GeoDecimal100Factory factory;
        Coordinate transformed;
        boolean b = true;
        if (coordinate != null && MathHelper.between((transformed = (factory = GeoDecimal100Factory.INSTANCE).createCoordinate(coordinate)).getX(), -180.0 * factory.getFactor(), 180.0 * factory.getFactor()) && MathHelper.between(transformed.getY(), -90.0 * factory.getFactor(), 90.0 * factory.getFactor()) && !MathHelper.between(transformed.getX(), -1.0, 1.0) && !MathHelper.between(transformed.getY(), -1.0, 1.0)) {
            b = false;
        }
        return b;
    }

    public static boolean isInEnvelope(Coordinate topLeft, Coordinate bottomRight, ImmutablePolygon envelope, double buffer) {
        if (envelope != null) {
            if (GeoUtils.isNullCoordinate(topLeft) || GeoUtils.isNullCoordinate(bottomRight)) {
                return false;
            }
            CoordinateFactory factory = envelope.getCoordinateFactory();
            Coordinate topLeftT = factory.createCoordinate(topLeft);
            Coordinate bottomRightT = factory.createCoordinate(bottomRight);
            buffer = buffer / GeoDecimal100Factory.INSTANCE.getRefScale() * factory.getRefScale();
            double minx = envelope.getMinX() - buffer;
            double maxx = envelope.getMaxX() + buffer;
            double miny = envelope.getMinY() - buffer;
            double maxy = envelope.getMaxY() + buffer;
            return topLeftT.getX() <= maxx && bottomRightT.getX() >= minx && topLeftT.getY() >= miny && bottomRightT.getY() <= maxy;
        }
        return true;
    }

    public static Map<ImmutablePoint, Integer> getMultipleExistingPoints(ImmutablePolygonKind immutablePolygonKind) {
        HashMap<ImmutablePoint, Integer> map = new HashMap<ImmutablePoint, Integer>();
        List<Object> polygonList = Collections.emptyList();
        if (immutablePolygonKind instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multi = (ImmutableMultiPolygon)immutablePolygonKind;
            polygonList = multi.getParts();
        } else if (immutablePolygonKind instanceof ImmutablePolygon) {
            polygonList = Collections.singletonList((ImmutablePolygon)immutablePolygonKind);
        }
        for (ImmutablePolygon polygon : polygonList) {
            Object count;
            ImmutablePoint first = null;
            for (ImmutablePoint point : polygon.getShell().getCoordinates()) {
                if (first == null) {
                    first = point;
                }
                if ((count = (Integer)map.get(point)) == null) {
                    map.put(point, 1);
                    continue;
                }
                map.put(point, (Integer)count + 1);
            }
            if (first != null) {
                Integer fCount = (Integer)map.get(first);
                map.put(first, fCount - 1);
            }
            for (ImmutableLineString hole : polygon.getHoles()) {
                first = null;
                count = hole.getCoordinates().iterator();
                while (count.hasNext()) {
                    Integer count2;
                    ImmutablePoint point = (ImmutablePoint)count.next();
                    if (first == null) {
                        first = point;
                    }
                    if ((count2 = (Integer)map.get(point)) == null) {
                        map.put(point, 1);
                        continue;
                    }
                    map.put(point, count2 + 1);
                }
                if (first == null) continue;
                Integer fCount = (Integer)map.get(first);
                map.put(first, fCount - 1);
            }
        }
        LinkedList toRemove = new LinkedList();
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            toRemove.add(entry.getKey());
        }
        for (ImmutablePoint point : toRemove) {
            map.remove(point);
        }
        return map;
    }

    public static boolean checkForNan(Collection<? extends ImmutableGeoObject> geoObjects) {
        for (ImmutableGeoObject immutableGeoObject : geoObjects) {
            boolean b = GeoUtils.checkForNan(immutableGeoObject);
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForNan(ImmutableGeoObject geoObject) {
        List<ImmutablePoint> coordinates = geoObject.getCoordinates();
        for (ImmutablePoint point : coordinates) {
            if (point.getX() != Double.NaN && point.getY() != Double.NaN) continue;
            return true;
        }
        return false;
    }

    public static boolean areSamedPoints(ImmutablePoint p1, ImmutablePoint p2, Double tolerance) {
        if (p1 == null || p2 == null || tolerance < 0.0) {
            return false;
        }
        return GeoUtils.areSamedPoints(p1.getCoordinate(), p2.getCoordinate(), tolerance);
    }

    public static boolean areSamedPoints(Coordinate c1, Coordinate c2, Double tolerance) {
        if (c1 == null || c2 == null || tolerance < 0.0) {
            return false;
        }
        return c1.equals(c2) || GeoUtils.getDistanceInMeter(c1, c2) <= tolerance;
    }

    public static double getDistanceFromStart(ImmutableLineString lineString, ImmutablePoint point) {
        ImmutablePoint basePoint = lineString.getBasePoint(point, null);
        double minDist = Double.MAX_VALUE;
        double distFromStart = 0.0;
        double bestDistFromStart = 0.0;
        Iterator<ImmutablePoint> iter = lineString.getCoordinates().iterator();
        ImmutablePoint pred = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            if (GeoUtils.areSamedPoints(pred, succ, (Double)0.0)) continue;
            ImmutableLineString part = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(pred, succ, new ImmutablePoint[0]);
            double distFromPart = part.distance(basePoint);
            if (distFromPart < minDist) {
                minDist = distFromPart;
                bestDistFromStart = distFromStart + pred.distance(basePoint);
            }
            distFromStart += part.getLength();
            pred = succ;
        }
        return bestDistFromStart;
    }

    public static double calculateAngle(ImmutablePoint zero, ImmutablePoint basePoint, ImmutablePoint point) {
        double angleBase = Math.atan2(basePoint.getY() - zero.getY(), basePoint.getX() - zero.getX());
        double anglePoint = Math.atan2(point.getY() - zero.getY(), point.getX() - zero.getX());
        double angle = anglePoint - angleBase;
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return ComputeTrigonometrics.normalizeAngle(angle);
    }

    public static Collection<Coordinate> getCoordinatesFromImmutableGeoObjects(Collection<? extends ImmutableGeoObject> geoObjects, CoordinateFactory coordinateFactory) {
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        for (ImmutableGeoObject immutableGeoObject : geoObjects) {
            List<ImmutablePoint> points = immutableGeoObject.getCoordinates();
            for (ImmutablePoint point : points) {
                coordinates.add(coordinateFactory.createCoordinate(point.getCoordinate()));
            }
        }
        return coordinates;
    }

    public static ImmutablePolygonKind removeEmptyPolygon(ImmutablePolygonKind immutablePolygonKind) {
        List<Object> polygonList = Collections.emptyList();
        if (immutablePolygonKind instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multi = (ImmutableMultiPolygon)immutablePolygonKind;
            polygonList = multi.getParts();
        } else if (immutablePolygonKind instanceof ImmutablePolygon) {
            polygonList = Collections.singletonList((ImmutablePolygon)immutablePolygonKind);
        }
        ArrayList<ImmutablePolygon> removed = new ArrayList<ImmutablePolygon>();
        for (ImmutablePolygon immutablePolygon : polygonList) {
            if (!GeoUtils.isEmptyPolygon(immutablePolygon)) continue;
            removed.add(immutablePolygon);
        }
        if (removed.isEmpty()) {
            return immutablePolygonKind;
        }
        ImmutablePolygonKind newPolygon = null;
        polygonList.removeAll(removed);
        if (polygonList.size() == 1) {
            newPolygon = (ImmutablePolygonKind)polygonList.get(0);
        } else if (polygonList.size() > 1) {
            newPolygon = ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(immutablePolygonKind.getCoordinateFactory(), polygonList);
        }
        return newPolygon;
    }

    private static boolean isEmptyPolygon(ImmutablePolygon polygon) {
        boolean isEmpty = true;
        if (polygon != null) {
            List<ImmutablePoint> points = polygon.getCoordinates();
            ImmutablePoint pred = null;
            for (ImmutablePoint point : points) {
                if (pred == null) {
                    pred = point;
                }
                if (point.equals(pred)) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public static ImmutablePolygonKind stripPolygonsFromImmutableGeoCollections(ImmutableGeoObject geoObject) {
        if (geoObject instanceof ImmutablePolygonKind) {
            return (ImmutablePolygonKind)geoObject;
        }
        if (geoObject instanceof ImmutableGeometryCollection) {
            ImmutableGeometryCollection collection = (ImmutableGeometryCollection)geoObject;
            List<ImmutableGeoObject> parts = collection.getParts();
            ArrayList<ImmutablePolygonKind> fParts = new ArrayList<ImmutablePolygonKind>(parts.size());
            for (ImmutableGeoObject o : parts) {
                if (!(o instanceof ImmutablePolygonKind)) continue;
                fParts.add((ImmutablePolygonKind)o);
            }
            return GeoUtils.mergePolygons(fParts);
        }
        return null;
    }

    private static ImmutablePolygonKind mergePolygons(List<ImmutablePolygonKind> fParts) {
        if (fParts.isEmpty()) {
            return null;
        }
        Iterator<ImmutablePolygonKind> iter = fParts.iterator();
        ImmutablePolygonKind result = iter.next();
        while (iter.hasNext()) {
            ImmutableGeoObject subResult = result.union(iter.next());
            if (!(subResult instanceof ImmutablePolygonKind)) continue;
            result = (ImmutablePolygonKind)subResult;
        }
        return result;
    }

    public static class SearchPolygon {
        private ImmutablePolygonKind polygon;
        private double minx;
        private double maxx;
        private double miny;
        private double maxy;
        private double distance;
        private double centerX;
        private double centerY;

        public SearchPolygon(ImmutablePolygonKind polygon, double minx, double maxx, double miny, double maxy, double distance, double centerX, double centerY) {
            this.polygon = polygon;
            this.minx = minx;
            this.maxx = maxx;
            this.miny = miny;
            this.maxy = maxy;
            this.distance = distance;
            this.centerX = centerX;
            this.centerY = centerY;
        }

        public ImmutablePolygonKind getPolygon() {
            return this.polygon;
        }

        public double getMinx() {
            return this.minx;
        }

        public double getMaxx() {
            return this.maxx;
        }

        public double getMiny() {
            return this.miny;
        }

        public double getMaxy() {
            return this.maxy;
        }

        public double getDistance() {
            return this.distance;
        }

        public double getCenterX() {
            return this.centerX;
        }

        public double getCenterY() {
            return this.centerY;
        }
    }

    public static enum Relation {
        INTERVAL_START,
        INTERVAL_END,
        INTERVAL_BEFORE,
        INTERVAL_AFTER,
        INTERVAL_WITHIN;

    }
}

