/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.renderer.AbstractLineRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.ktde.math.projection.Coordinate;

public class SolidLineRenderer<U>
extends AbstractLineRenderer<RendererProperties, U> {
    private Color fixedColor;
    private double width;

    public SolidLineRenderer(Color fixedColor) {
        this(fixedColor, null);
    }

    public SolidLineRenderer(Color fixedColor, Double width) {
        this.fixedColor = fixedColor;
        this.width = width == null ? 5.0 : width;
    }

    public static void render(Graphics2D g2d, ImmutableLineString geom) {
        boolean first = true;
        Line2D.Double line = new Line2D.Double();
        for (ImmutablePoint immutablePoint : geom.getCoordinates()) {
            line.x1 = line.x2;
            line.y1 = line.y2;
            Coordinate c = immutablePoint.getCoordinate();
            line.x2 = c.getX();
            line.y2 = c.getY();
            if (first) {
                first = false;
                continue;
            }
            g2d.draw(line);
        }
    }

    @Override
    public RendererProperties createRendererProperties(U u) {
        return new DefaultRendererProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(20, 10);
    }

    @Override
    protected void render(Graphics2D g2d, U u, Path2D[] paths, RendererProperties rendererProperties) {
        g2d.setColor(this.fixedColor);
        BasicStroke stroke = new BasicStroke((float)(this.width * rendererProperties.getUpp()));
        g2d.setStroke(stroke);
        for (int i = 0; i < paths.length; ++i) {
            g2d.draw(paths[i]);
        }
    }

    public static enum Parameters {
        COLOR,
        WIDTH;

    }
}

