/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.renderer.AbstractShapePointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class RectanglePointRenderer<U>
extends AbstractShapePointRenderer<U> {
    private Integer height;
    private Integer width;

    public RectanglePointRenderer(Color fixedColor, Integer alpha, Integer height, Integer width) {
        super(fixedColor, alpha);
        this.height = height;
        this.width = width;
    }

    @Override
    protected void setParamsInternal(String[] params) {
        this.height = Integer.valueOf(params[1]);
        this.width = Integer.valueOf(params[2]);
    }

    @Override
    public void render(Graphics2D g2d, U u, ImmutablePoint geom, RendererProperties rendererProperties) {
        Color fixedColor = this.getFixedColor();
        if (fixedColor.getAlpha() > 0) {
            Stroke setStroke = g2d.getStroke();
            Color setColor = g2d.getColor();
            g2d.setColor(fixedColor);
            g2d.setStroke(new BasicStroke((float)rendererProperties.getUpp()));
            double aHeight = (double)this.height.intValue() * rendererProperties.getUpp();
            double aWidth = (double)this.width.intValue() * rendererProperties.getUpp();
            Rectangle2D.Double rectangle = new Rectangle2D.Double(geom.getX() - aWidth / 2.0, geom.getY() - aHeight / 2.0, aWidth, aHeight);
            g2d.fill(rectangle);
            g2d.setColor(Color.BLACK);
            g2d.draw(rectangle);
            g2d.setColor(setColor);
            g2d.setStroke(setStroke);
        }
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(this.width, this.height);
    }

    public static enum Parameters {
        COLOR,
        ALPHA,
        HEIGHT,
        WIDTH;

    }
}

