/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.collection.CyclingIterator;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RandomAreaRenderer<U>
extends AbstractRenderer<RendererProperties, ImmutablePolygonKind, U>
implements AreaRenderer<RendererProperties, U> {
    private Map<U, AreaRenderer<RendererProperties, U>> rendererMap = new HashMap<U, AreaRenderer<RendererProperties, U>>();
    private Iterator<AreaRenderer<RendererProperties, U>> rendererIterator;
    private AreaRenderer<? extends RendererProperties, U> emphasizeRenderer;

    public RandomAreaRenderer(Iterable<AreaRenderer<RendererProperties, U>> iter, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        this.rendererIterator = new CyclingIterator<AreaRenderer<RendererProperties, U>>(iter);
        this.emphasizeRenderer = emphasizeRenderer;
    }

    @Override
    public void render(Graphics2D g2d, U u, ImmutablePolygonKind geom, RendererProperties rendererProperties) {
        AreaRenderer<RendererProperties, U> areaRenderer = this.getRenderer(u);
        areaRenderer.render(g2d, u, geom, rendererProperties);
    }

    @Override
    public void render(Graphics2D g2d, U u, Collection<ImmutablePolygonKind> geom, RendererProperties rendererProperties) {
        AreaRenderer<RendererProperties, U> areaRenderer = this.getRenderer(u);
        areaRenderer.render(g2d, u, geom, rendererProperties);
    }

    private AreaRenderer<RendererProperties, U> getRenderer(U u) {
        AreaRenderer<RendererProperties, U> areaRenderer = this.rendererMap.get(u);
        if (areaRenderer == null) {
            areaRenderer = this.rendererIterator.next();
            this.rendererMap.put(u, areaRenderer);
        }
        return areaRenderer;
    }

    @Override
    public RendererProperties createRendererProperties(U u) {
        AreaRenderer<RendererProperties, U> areaRenderer = this.getRenderer(u);
        return areaRenderer.createRendererProperties(u);
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(10, 10);
    }

    @Override
    public AreaRenderer<? extends RendererProperties, U> emphazise(U u) {
        if (this.emphasizeRenderer == null) {
            AreaRenderer<RendererProperties, U> areaRenderer = this.getRenderer(u);
            return areaRenderer.emphazise(u);
        }
        return this.emphasizeRenderer;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static enum Parameters {
        ALPHA;

    }
}

