/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.Collection;

public class IconPointRenderer<U>
extends AbstractRenderer<RendererProperties, ImmutablePoint, U>
implements PointRenderer<RendererProperties, U> {
    private Image image;

    public IconPointRenderer(Image image) {
        this.image = image;
    }

    @Override
    public RendererProperties createRendererProperties(U u) {
        return new DefaultRendererProperties();
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        if (this.image == null) {
            return new Dimension();
        }
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    @Override
    public void render(Graphics2D g2d, U u, ImmutablePoint geom, RendererProperties rendererProperties) {
        if (this.image != null) {
            AffineTransform transform = g2d.getTransform();
            double scaleX = transform.getScaleX();
            double scaleY = transform.getScaleY();
            g2d.scale(1.0 / scaleX, 1.0 / scaleY);
            int width = this.image.getWidth(null) / 2;
            int height = this.image.getHeight(null) / 2;
            double x = geom.getX() * scaleX;
            double y = geom.getY() * scaleY;
            g2d.drawImage(this.image, (int)Math.round(x - (double)width), (int)Math.round(y - (double)height), null);
            g2d.setTransform(transform);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void render(Graphics2D g2d, U u, Collection<ImmutablePoint> geom, RendererProperties rendererProperties) {
        if (geom != null) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }
    }

    public static enum Parameters {
        IMAGE_ID;

    }
}

