/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.renderer.AbstractShapePointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class CirclePointRenderer<U>
extends AbstractShapePointRenderer<U> {
    private Integer radius;

    public CirclePointRenderer(Color color, Integer alpha, Integer radius) {
        super(color, alpha);
        this.radius = radius;
    }

    @Override
    protected void setParamsInternal(String[] params) {
        this.radius = Integer.valueOf(params[1]);
    }

    @Override
    public void render(Graphics2D g2d, U u, ImmutablePoint geom, RendererProperties rendererProperties) {
        Color fixedColor = this.getFixedColor();
        if (fixedColor.getAlpha() > 0) {
            Stroke setStroke = g2d.getStroke();
            Color setColor = g2d.getColor();
            g2d.setColor(fixedColor);
            g2d.setStroke(new BasicStroke((float)rendererProperties.getUpp()));
            double aRadius = (double)this.radius.intValue() * rendererProperties.getUpp();
            Ellipse2D.Double ellipse = new Ellipse2D.Double(geom.getX() - aRadius, geom.getY() - aRadius, aRadius * 2.0, aRadius * 2.0);
            g2d.fill(ellipse);
            g2d.setColor(Color.BLACK);
            g2d.draw(ellipse);
            g2d.setColor(setColor);
            g2d.setStroke(setStroke);
        }
    }

    @Override
    public Dimension getOptimalPreviewDimension() {
        return new Dimension(this.radius * 2, this.radius * 2);
    }

    public static enum Parameters {
        COLOR,
        ALPHA,
        RADIUS;

    }
}

