/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collection;

public abstract class AbstractShapePointRenderer<U>
extends AbstractRenderer<RendererProperties, ImmutablePoint, U>
implements PointRenderer<RendererProperties, U> {
    private Color fixedColor;

    public AbstractShapePointRenderer(Color fixedColor, Integer alpha) {
        this.fixedColor = fixedColor;
        if (fixedColor == null) {
            this.fixedColor = Color.BLUE;
        }
        if (alpha != null) {
            Integer tAlpha = PaintUtil.transform100BaseAlpha(alpha);
            this.fixedColor = new Color(this.fixedColor.getRed(), this.fixedColor.getGreen(), this.fixedColor.getBlue(), tAlpha);
        }
    }

    @Override
    public RendererProperties createRendererProperties(U u) {
        return new RendererProperties(){
            private double upp;

            @Override
            public void setUpp(double upp) {
                this.upp = upp;
            }

            @Override
            public double getUpp() {
                return this.upp;
            }
        };
    }

    protected abstract void setParamsInternal(String[] var1);

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Color getFixedColor() {
        return this.fixedColor;
    }

    @Override
    public void render(Graphics2D g2d, U u, Collection<ImmutablePoint> geom, RendererProperties rendererProperties) {
        if (geom != null) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }
    }
}

