/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractLineRenderer<T extends RendererProperties, U>
extends AbstractRenderer<T, ImmutableLineString, U>
implements LineRenderer<T, U> {
    @Override
    public void render(Graphics2D g2d, U u, ImmutableLineString geom, T rendererProperties) {
        this.render(g2d, u, (Collection<ImmutableLineString>)Collections.singleton(geom), rendererProperties);
    }

    @Override
    public void render(Graphics2D g2d, U u, Collection<ImmutableLineString> geom, T rendererProperties) {
        Path2D[] paths = new Path2D[geom.size()];
        int count = 0;
        for (ImmutableLineString lineString : geom) {
            paths[count++] = PaintUtil.createPath2D(lineString);
        }
        this.render(g2d, u, paths, rendererProperties);
    }

    @Override
    protected abstract void render(Graphics2D var1, U var2, Path2D[] var3, T var4);

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

