/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing.renderer;

import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAreaRenderer<T extends RendererProperties, U>
extends AbstractRenderer<T, ImmutablePolygonKind, U>
implements AreaRenderer<T, U> {
    private static Map<ImmutablePolygonKind, ImmutablePolygonKind> badRepairedPolygons = new HashMap<ImmutablePolygonKind, ImmutablePolygonKind>();
    private static Set<ImmutablePolygonKind> realBadPolygons = new HashSet<ImmutablePolygonKind>();
    private AreaRenderer<? extends RendererProperties, U> emphasizeRenderer;

    public AbstractAreaRenderer(AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        this.emphasizeRenderer = emphasizeRenderer;
    }

    @Override
    public void render(Graphics2D g2d, U u, ImmutablePolygonKind geom, T rendererProperties) {
        this.configureGraphics(g2d, rendererProperties);
        geom = this.clipGeom(g2d, geom);
        if (geom != null) {
            Area[] areas;
            for (Area area : areas = PaintUtil.createPolygonArea(geom)) {
                g2d.fill(area);
            }
        }
        this.resetGraphics(g2d);
    }

    protected void resetGraphics(Graphics2D g2d) {
    }

    protected abstract void configureGraphics(Graphics2D var1, T var2);

    @Override
    public void render(Graphics2D g2d, U u, Collection<ImmutablePolygonKind> geom, T rendererProperties) {
        this.configureGraphics(g2d, rendererProperties);
        for (ImmutablePolygonKind immutablePolygonKind : geom) {
            Area[] areas;
            ImmutablePolygonKind immutablePolygonKind2 = this.clipGeom(g2d, immutablePolygonKind);
            if (immutablePolygonKind2 == null) continue;
            for (Area area : areas = PaintUtil.createPolygonArea(immutablePolygonKind2)) {
                g2d.fill(area);
            }
        }
        this.resetGraphics(g2d);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private ImmutablePolygonKind clipGeom(Graphics2D g2d, ImmutablePolygonKind geom) {
        if (realBadPolygons.contains(geom)) {
            return geom;
        }
        Rectangle clipBounds = g2d.getClipBounds();
        ImmutableEnvelope env = new ImmutableEnvelope(geom.getCoordinateFactory().createCoordinate(clipBounds.getMaxX(), clipBounds.getMaxY()), geom.getCoordinateFactory().createCoordinate(clipBounds.getMinX(), clipBounds.getMinY()));
        return this.clipGeom(geom, env);
    }

    private ImmutablePolygonKind clipGeom(ImmutablePolygonKind geom, ImmutableEnvelope env) {
        ImmutablePolygonKind bad = badRepairedPolygons.get(geom);
        if (bad != null) {
            ImmutableGeoObject intersection = bad.intersection(env);
            return GeoUtils.stripPolygonsFromImmutableGeoCollections(intersection);
        }
        try {
            ImmutableGeoObject intersection = geom.intersection(env);
            geom = GeoUtils.stripPolygonsFromImmutableGeoCollections(intersection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return geom;
    }

    @Override
    public AreaRenderer<? extends RendererProperties, U> emphazise(U u) {
        if (this.emphasizeRenderer == null) {
            return this.emphaziseDefault(u);
        }
        return this.emphasizeRenderer;
    }

    protected abstract AreaRenderer<? extends RendererProperties, U> emphaziseDefault(U var1);
}

