/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public class RulerRenderer
extends AbstractEnhancedMouseManipulatorAction
implements NavigatorRenderer {
    private static final long serialVersionUID = -3717262016051508476L;
    private List<Point2D.Double> allPoints = new ArrayList<Point2D.Double>(20);
    private List<Point2D.Double> fixedPoints = new ArrayList<Point2D.Double>(20);
    private String rendererName;
    private NavigatorPanel navigatorPanel;
    private boolean active;
    private boolean started = false;
    private List<NavigatorRendererActiveListener> navigatorRendererActiveListeners;
    private Cursor cursor;
    private int sortOrder = Integer.MAX_VALUE;

    public RulerRenderer(NavigatorPanel navigatorPanel, String title, String renderName) {
        super(navigatorPanel, null, title);
        this.rendererName = renderName;
        this.navigatorPanel = navigatorPanel;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(NavigatorPanel.class.getResource("/de/datomino/util/geo/swing/cursor/ruler.png"));
        this.cursor = toolkit.createCustomCursor(image, new Point(16, 16), "ruler");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }

    @Override
    public synchronized Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.isActive() && !this.allPoints.isEmpty()) {
            long distanceSum = 0L;
            int size = this.allPoints.size();
            for (int i = 1; i < size; ++i) {
                double sX = this.allPoints.get(i - 1).getX();
                double sY = this.allPoints.get(i - 1).getY();
                double eX = this.allPoints.get(i).getX();
                double eY = this.allPoints.get(i).getY();
                g2d.setColor(Color.BLACK);
                BasicStroke stroke = new BasicStroke((float)(upp * 2.0));
                g2d.setStroke(stroke);
                Path2D.Double path = new Path2D.Double();
                path.moveTo(sX, sY);
                path.lineTo(eX, eY);
                g2d.draw(path);
                double distance = GeoUtils.getDistanceInMeter(this.navigatorPanel.getCoordinateFactory().createCoordinate(this.allPoints.get(i - 1)), this.navigatorPanel.getCoordinateFactory().createCoordinate(this.allPoints.get(i)));
                long rDistance = Math.round(distance);
                distanceSum += rDistance;
                String distanceString = rDistance + " m";
                AffineTransform affineTransform = g2d.getTransform();
                double scaleX = affineTransform.getScaleX() / 1.5;
                double scaleY = affineTransform.getScaleY() / 1.5;
                AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
                g2d.transform(flip);
                FontMetrics fontMetrics = g2d.getFontMetrics();
                double height = fontMetrics.getHeight();
                double width = fontMetrics.stringWidth(distanceString);
                Point2D.Double dst = new Point2D.Double();
                AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double((sX + eX) / 2.0, (sY + eY) / 2.0), dst);
                g2d.drawString(distanceString, (float)(dst.getX() - width / 2.0), (float)(dst.getY() - height / 2.0));
                g2d.setTransform(affineTransform);
            }
            if (size > 2) {
                String sumDistanceString = distanceSum + " m";
                AffineTransform affineTransform = g2d.getTransform();
                double scaleX = affineTransform.getScaleX() / 1.5;
                double scaleY = affineTransform.getScaleY() / 1.5;
                AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
                g2d.transform(flip);
                FontMetrics fontMetrics = g2d.getFontMetrics();
                double height = fontMetrics.getHeight();
                double width = fontMetrics.stringWidth(sumDistanceString);
                Point2D.Double dst = new Point2D.Double();
                double endX = this.allPoints.get(size - 1).getX();
                double endY = this.allPoints.get(size - 1).getY();
                AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(endX, endY), dst);
                g2d.drawString(sumDistanceString, (float)(dst.getX() - width / 2.0), (float)(dst.getY() - height / 2.0));
                g2d.setTransform(affineTransform);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    @Override
    public String getName() {
        return this.rendererName;
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        if (this.navigatorRendererActiveListeners == null) {
            this.navigatorRendererActiveListeners = new LinkedList<NavigatorRendererActiveListener>();
        }
        this.navigatorRendererActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        if (this.navigatorRendererActiveListeners == null) {
            this.navigatorRendererActiveListeners = new LinkedList<NavigatorRendererActiveListener>();
        }
        this.navigatorRendererActiveListeners.remove(navigatorPanelActiveListener);
    }

    @Override
    protected void turnedOn() {
        this.active = true;
        this.getNavigatorPanel().setCursor(this.cursor);
        this.fireNavigatorRendererActivateEvent(new NavigatorRendererActivateEvent(this, true));
    }

    @Override
    protected void turnedOff() {
        this.active = false;
        this.allPoints.clear();
        this.fixedPoints.clear();
        this.started = false;
        this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        this.fireNavigatorRendererActivateEvent(new NavigatorRendererActivateEvent(this, false));
        this.getNavigatorPanel().repaint(1L);
    }

    @Override
    protected synchronized void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected synchronized void mouseDragged(int x, int y) {
    }

    @Override
    protected synchronized void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        if (this.isActive()) {
            if (!this.started) {
                if (mouseButton == MouseButton.BUTTON1) {
                    this.started = true;
                    this.fixedPoints.add(this.navigatorPanel.getReal(x, y));
                }
            } else if (mouseButton == MouseButton.BUTTON1) {
                this.started = false;
                this.allPoints.clear();
                this.fixedPoints.clear();
                this.getNavigatorPanel().repaint(1L);
            } else if (mouseButton == MouseButton.BUTTON2) {
                this.fixedPoints.add(this.navigatorPanel.getReal(x, y));
            }
        }
    }

    @Override
    protected void mouseMoved(int x, int y) {
        if (this.isActive() && this.started) {
            this.allPoints.clear();
            this.allPoints.addAll(this.fixedPoints);
            this.allPoints.add(this.navigatorPanel.getReal(x, y));
            this.getNavigatorPanel().repaint(1L);
        }
    }

    @Override
    protected Integer getTimerInterval() {
        return 1;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void fireNavigatorRendererActivateEvent(NavigatorRendererActivateEvent navigatorPanelActivateEvent) {
        if (this.navigatorRendererActiveListeners != null) {
            for (NavigatorRendererActiveListener navigatorRendererActiveListener : this.navigatorRendererActiveListeners) {
                navigatorRendererActiveListener.valueChanged(navigatorPanelActivateEvent);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

