/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.html.StyleSheet;
import org.apache.commons.lang.StringUtils;
import org.ktde.swing.graphics.Polygon2D;
import org.ktde.util.datatypes.Tupel;

public final class PaintUtil {
    public static final List<Tupel<Color, Color>> DEFCOLORS;
    public static final List<Tupel<Color, Color>> SYSCOLORS;
    private static final Color BROWN;
    private static final Color DARK_GREEN;
    private static final Color WHALE_BLUE;
    public static final Tupel<Color, Color> ERROR_COLOR;
    public static final Tupel<Color, Color> DISABLED_COLOR;
    public static final List<Color> RANDOM_COLORS;

    public static Tupel<Color, Color> getColorFromCode(Integer colorCode) {
        if (colorCode == null || colorCode.compareTo(0) == 0) {
            return DISABLED_COLOR;
        }
        if (colorCode < 0) {
            return SYSCOLORS.get((-1 - colorCode) % SYSCOLORS.size());
        }
        return DEFCOLORS.get((colorCode - 1) % DEFCOLORS.size());
    }

    public static Tupel<Color, Color> getColorFromCode(Long colorCode) {
        int c = 0;
        if (colorCode != null) {
            c = (int)(colorCode % 0x7FFFFFFEL + 1L);
        }
        return PaintUtil.getColorFromCode(c);
    }

    public static Area createPolygonArea(ImmutablePolygon geom) {
        ImmutableLineString shell = geom.getShell();
        Area polyarea = PaintUtil.createPolyringArea(shell);
        if (polyarea != null) {
            for (ImmutableLineString lineStringA : geom.getHoles()) {
                Area subpolyarea = PaintUtil.createPolyringArea(lineStringA);
                if (subpolyarea == null) continue;
                polyarea.exclusiveOr(subpolyarea);
            }
        }
        return polyarea;
    }

    public static Area createPolygonArea(ImmutablePolygon geom, AffineTransform at) {
        ImmutableLineString shell = geom.getShell();
        Area polyarea = PaintUtil.createPolyringArea(shell, at);
        for (ImmutableLineString lineStringA : geom.getHoles()) {
            Area subpolyarea = PaintUtil.createPolyringArea(lineStringA, at);
            polyarea.exclusiveOr(subpolyarea);
        }
        return polyarea;
    }

    public static Area[] createPolygonArea(ImmutablePolygonKind geom) {
        if (geom instanceof ImmutablePolygon) {
            Area[] areaArray;
            Area area = PaintUtil.createPolygonArea((ImmutablePolygon)geom);
            if (area == null) {
                areaArray = new Area[]{};
            } else {
                Area[] areaArray2 = new Area[1];
                areaArray = areaArray2;
                areaArray2[0] = area;
            }
            return areaArray;
        }
        if (geom instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)geom;
            List parts = multiPolygon.getParts();
            Area[] areas = new Area[parts.size()];
            int count = 0;
            for (ImmutablePolygon polygon : parts) {
                areas[count] = PaintUtil.createPolygonArea(polygon);
                ++count;
            }
            return areas;
        }
        throw new IllegalArgumentException();
    }

    public static Area[] createPolygonArea(ImmutablePolygonKind geom, AffineTransform at) {
        if (geom instanceof ImmutablePolygon) {
            return new Area[]{PaintUtil.createPolygonArea((ImmutablePolygon)geom, at)};
        }
        if (geom instanceof ImmutableMultiPolygon) {
            ImmutableMultiPolygon multiPolygon = (ImmutableMultiPolygon)geom;
            List parts = multiPolygon.getParts();
            Area[] areas = new Area[parts.size()];
            int count = 0;
            for (ImmutablePolygon polygon : parts) {
                areas[count] = PaintUtil.createPolygonArea(polygon, at);
                ++count;
            }
            return areas;
        }
        throw new IllegalArgumentException();
    }

    public static Area createPolyringArea(ImmutableLineString lineString) {
        List<ImmutablePoint> coordinates = lineString.getCoordinates();
        if (coordinates.isEmpty()) {
            return null;
        }
        Polygon2D.Double p2d = new Polygon2D.Double();
        boolean init = false;
        for (ImmutablePoint immutablePoint : coordinates) {
            if (!init) {
                init = true;
                ((Polygon2D)p2d).moveTo(immutablePoint.getX(), immutablePoint.getY());
                continue;
            }
            ((Polygon2D)p2d).lineTo(immutablePoint.getX(), immutablePoint.getY());
        }
        Area polyarea = new Area(p2d);
        return polyarea;
    }

    public static Area createPolyringArea(ImmutableLineString lineString, AffineTransform at) {
        Polygon2D.Double p2d = new Polygon2D.Double();
        boolean init = false;
        Point2D last = null;
        for (ImmutablePoint immutablePoint : lineString.getCoordinates()) {
            double x = immutablePoint.getX();
            double y = immutablePoint.getY();
            Point2D.Double next = new Point2D.Double(x, y);
            Point2D nextTransformed = at.transform(next, null);
            if (last != null) {
                long nx = Math.round(nextTransformed.getX());
                long ny = Math.round(nextTransformed.getY());
                long lx = Math.round(last.getX());
                long ly = Math.round(last.getY());
                if (nx == lx && ny == ly) {
                    last = nextTransformed;
                    continue;
                }
            }
            if (!init) {
                init = true;
                p2d.moveTo(next);
            } else {
                p2d.lineTo(next);
            }
            last = nextTransformed;
        }
        Area polyarea = new Area(p2d);
        return polyarea;
    }

    public static Color extractColor(int pos, String ... string) {
        StringTokenizer st;
        String colorString;
        StyleSheet myStylesheet;
        Color result = null;
        if (string.length > pos && (result = (myStylesheet = new StyleSheet()).stringToColor(colorString = (st = new StringTokenizer(string[0], "@")).nextToken())) != null && st.hasMoreTokens()) {
            String alphaString = st.nextToken();
            int base = 16;
            if (alphaString.startsWith(".")) {
                alphaString = (alphaString + "00").substring(1, 3);
                base = 10;
            } else if (alphaString.startsWith("0.")) {
                alphaString = (alphaString + "00").substring(2, 4);
                base = 10;
            } else if (alphaString.startsWith("1.")) {
                alphaString = "100";
                base = 10;
            }
            int alpha = Integer.valueOf(alphaString, base);
            if (base == 10) {
                alpha = PaintUtil.transform100BaseAlpha(alpha);
            }
            result = new Color(result.getRGB() & (0xFFFFFF | alpha << 24), true);
        }
        return result;
    }

    public static Double extractDouble(int pos, String ... string) {
        Double result = null;
        if (string.length > pos) {
            result = Double.valueOf(string[pos]);
        }
        return result;
    }

    public static String getColorString(Color color, boolean addAlpha) {
        StringBuilder sb = new StringBuilder("#");
        sb.append(StringUtils.leftPad(Integer.toHexString(color.getRed()), 2, '0'));
        sb.append(StringUtils.leftPad(Integer.toHexString(color.getGreen()), 2, '0'));
        sb.append(StringUtils.leftPad(Integer.toHexString(color.getBlue()), 2, '0'));
        if (addAlpha) {
            sb.append("@");
            double alpha = color.getAlpha();
            String dAlpha = StringUtils.leftPad(Integer.toString((int)Math.round(alpha * 2.55)), 2, '0');
            sb.append(dAlpha.substring(0, 1)).append(".").append(dAlpha.substring(1, 3));
        }
        return sb.toString();
    }

    public static Integer transform100BaseAlpha(Integer alpha) {
        return Math.max(0, Math.min(255, (int)Math.round((double)(alpha == null ? 100 : alpha) / 100.0 * 255.0)));
    }

    public static Path2D createPath2D(ImmutableLineString geom) {
        Path2D.Double p2d = new Path2D.Double();
        boolean init = true;
        for (ImmutablePoint immutablePoint : geom.getCoordinates()) {
            double x = immutablePoint.getX();
            double y = immutablePoint.getY();
            if (init) {
                init = false;
                ((Path2D)p2d).moveTo(x, y);
                continue;
            }
            ((Path2D)p2d).lineTo(x, y);
        }
        return p2d;
    }

    public static Path2D createPath2D(ImmutableLineString geom, AffineTransform at) {
        Path2D.Double p2d = new Path2D.Double();
        boolean init = false;
        Point2D last = null;
        for (ImmutablePoint immutablePoint : geom.getCoordinates()) {
            double x = immutablePoint.getX();
            double y = immutablePoint.getY();
            Point2D.Double next = new Point2D.Double(x, y);
            Point2D nextTransformed = at.transform(next, null);
            if (last != null) {
                long nx = Math.round(nextTransformed.getX());
                long ny = Math.round(nextTransformed.getY());
                long lx = Math.round(last.getX());
                long ly = Math.round(last.getY());
                if (nx == lx && ny == ly) {
                    last = nextTransformed;
                    continue;
                }
            }
            if (!init) {
                init = true;
                ((Path2D)p2d).moveTo(x, y);
            } else {
                ((Path2D)p2d).lineTo(x, y);
            }
            last = nextTransformed;
        }
        return p2d;
    }

    public static Color getComplementColor(Color color) {
        return new Color((color.getRed() + 128) % 255, (color.getGreen() + 128) % 255, (color.getBlue() + 128) % 255);
    }

    public static Integer transform256BaseAlpha(Integer alpha) {
        if (alpha == null) {
            return 255;
        }
        return (int)Math.round((double)alpha.intValue() / 255.0 * 100.0);
    }

    static {
        BROWN = new Color(139, 69, 19);
        DARK_GREEN = new Color(59, 83, 35);
        WHALE_BLUE = new Color(66, 100, 127);
        ERROR_COLOR = new Tupel<Color, Color>(Color.RED, Color.RED);
        DISABLED_COLOR = new Tupel<Color, Color>(Color.GRAY, Color.GRAY);
        ArrayList<Tupel<Color, Color>> defColors = new ArrayList<Tupel<Color, Color>>();
        defColors.add(new Tupel<Color, Color>(Color.BLUE, Color.BLUE));
        defColors.add(new Tupel<Color, Color>(Color.GREEN, Color.GREEN));
        defColors.add(new Tupel<Color, Color>(Color.CYAN, Color.CYAN));
        defColors.add(new Tupel<Color, Color>(Color.MAGENTA, Color.MAGENTA));
        defColors.add(new Tupel<Color, Color>(BROWN, BROWN));
        defColors.add(new Tupel<Color, Color>(WHALE_BLUE, WHALE_BLUE));
        defColors.add(new Tupel<Color, Color>(DARK_GREEN, DARK_GREEN));
        int countColors = defColors.size();
        for (int inner = 1; inner < countColors; ++inner) {
            for (int outer = inner + 1; outer < countColors; ++outer) {
                defColors.add(new Tupel(((Tupel)defColors.get(inner)).getElement1(), ((Tupel)defColors.get(outer)).getElement1()));
            }
        }
        DEFCOLORS = Collections.unmodifiableList(defColors);
        List<Tupel> asList = Arrays.asList(new Tupel<Color, Color>(Color.BLACK, Color.BLACK), new Tupel<Color, Color>(Color.RED, Color.RED), new Tupel<Color, Color>(Color.WHITE, Color.WHITE));
        SYSCOLORS = Collections.unmodifiableList(asList);
        RANDOM_COLORS = Collections.unmodifiableList(Arrays.asList(new Color(0, 0, 255), new Color(255, 0, 0), new Color(0, 94, 0), new Color(0, 0, 0), new Color(255, 215, 0), new Color(100, 149, 237), new Color(255, 140, 0), new Color(126, 252, 0), new Color(128, 128, 128), new Color(75, 0, 130), new Color(255, 105, 180), new Color(0, 139, 139), new Color(139, 69, 19), new Color(127, 255, 212), new Color(153, 50, 204)));
    }
}

