/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.ValueChangeObservable;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import de.datomino.util.geo.swing.ObjectSelectionHandler;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public class ObjectSelectorNavigatorRenderer<S extends ValueChangeObservable, T extends ImmutableGeoObject>
extends AbstractEnhancedMouseManipulatorAction
implements NavigatorRenderer {
    private static final long serialVersionUID = 7368703372694682198L;
    private static final Color HOVERCOLOR = new Color(127, 255, 127, 127);
    private GeoObjectBucketsModel<S, T> bucketsModel;
    private S hover;
    private Cursor hoverCursor;
    private ObjectSelectionHandler<S> handler;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private RendererChecker<S> rendererChecker;
    private int sortOrder = Integer.MAX_VALUE;

    public ObjectSelectorNavigatorRenderer(NavigatorPanel navigatorPanel, Double maxUpp, String title, GeoObjectBucketsModel<S, T> bucketsModel, ObjectSelectionHandler<S> handler) {
        super(navigatorPanel, maxUpp, title);
        this.bucketsModel = bucketsModel;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/cross.png"));
        this.hoverCursor = toolkit.createCustomCursor(image, new Point(16, 16), "img");
        this.handler = handler;
    }

    public double getUppScale(double upp) {
        return Math.pow(upp, 0.3);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        int width = this.getNavigatorPanel().getWidth();
        int height = this.getNavigatorPanel().getHeight();
        if (height > 0 && width > 0) {
            Graphics2D g2da = g2d;
            if (this.hover != null) {
                this.render(this.hover, g2da, upp, HOVERCOLOR);
            }
        }
        return Collections.emptyList();
    }

    public void render(S model, Graphics2D g2d, double upp, Color color) {
        Object geom = this.bucketsModel.extractGeom(model);
        if (geom != null) {
            if ((geom = geom.getTransformed(this.getNavigatorPanel().getCoordinateFactory())) instanceof ImmutablePoint) {
                this.drawPoint(g2d, (ImmutablePoint)geom, upp, color);
            } else if (geom instanceof ImmutableLineString) {
                this.drawLineString(g2d, (ImmutableLineString)geom, upp, color);
            } else if (geom instanceof ImmutablePolygon) {
                this.drawPolygon(g2d, (ImmutablePolygon)geom, upp, color);
            } else if (geom instanceof ImmutableMultiPolygon) {
                this.drawMultiPolygon(g2d, (ImmutableMultiPolygon)geom, upp, color);
            } else {
                throw new IllegalArgumentException("Not supported geoObject: " + geom);
            }
        }
    }

    protected void drawMultiPolygon(Graphics2D g2d, ImmutableMultiPolygon geom, double upp, Color color) {
        for (ImmutablePolygon immutablePolygon : geom.getParts()) {
            this.drawPolygon(g2d, immutablePolygon, upp, color);
        }
    }

    protected void drawPolygon(Graphics2D g2d, ImmutablePolygon geom, double upp, Color color) {
        g2d.setColor(color);
        g2d.fill(PaintUtil.createPolygonArea(geom));
    }

    protected void drawLineString(Graphics2D g2d, ImmutableLineString geom, double upp, Color color) {
        double margin = 15.0 * this.getUppScale(upp);
        boolean first = true;
        g2d.setColor(color);
        BasicStroke stroke = new BasicStroke((float)margin, 1, 1);
        g2d.setStroke(stroke);
        List<ImmutablePoint> coordinates = geom.getCoordinates();
        GeneralPath line = new GeneralPath(0, coordinates.size());
        for (ImmutablePoint immutablePoint : coordinates) {
            Coordinate c = immutablePoint.getCoordinate();
            if (first) {
                line.moveTo(c.getX(), c.getY());
                first = false;
                continue;
            }
            line.lineTo(c.getX(), c.getY());
        }
        g2d.draw(line);
    }

    protected void drawPoint(Graphics2D g2d, ImmutablePoint geom, double upp, Color color) {
        g2d.setColor(color);
        double margin = 5.0 * this.getUppScale(upp);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        Coordinate c = geom.getCoordinate();
        ellipse.x = c.getX() - margin;
        ellipse.y = c.getY() - margin;
        ellipse.width = 2.0 * margin;
        ellipse.height = 2.0 * margin;
        g2d.fill(ellipse);
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        Coordinate mouseNow = this.createCoordinateForPixel(x, y);
        Collection<S> marked = this.bucketsModel.findObjects(mouseNow, 5.0 * this.getNavigatorPanel().getUpp());
        this.mouseClicked(this.getFilteredObjects(marked), clickCount, modifiers);
    }

    protected Collection<S> getFilteredObjects(Collection<S> ss) {
        if (this.rendererChecker == null) {
            return ss;
        }
        LinkedList<ValueChangeObservable> list = new LinkedList<ValueChangeObservable>();
        for (ValueChangeObservable s : ss) {
            if (!this.rendererChecker.isToBeRendered(s)) continue;
            list.add(s);
        }
        return list;
    }

    protected void mouseClicked(Collection<S> marked, int clickCount, int modifiers) {
        this.doSelect(marked, modifiers);
    }

    protected void doSelect(Collection<S> marked, int modifiers) {
        if ((modifiers & 2) > 0) {
            if (marked != null && !marked.isEmpty()) {
                for (ValueChangeObservable o : marked) {
                    this.handler.toggleSelection(Collections.singleton(o));
                }
            }
        } else {
            this.handler.select(marked);
        }
        this.getNavigatorPanel().repaint();
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    protected void mouseDragged(int x, int y) {
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseMoved(int x, int y) {
        Coordinate mouseNow = this.createCoordinateForPixel(x, y);
        Collection<S> underMouse = this.getFilteredObjects(this.bucketsModel.findObjects(mouseNow, 5.0 * this.getNavigatorPanel().getUpp()));
        if (!underMouse.isEmpty()) {
            ValueChangeObservable o = (ValueChangeObservable)underMouse.iterator().next();
            if (this.hover != o) {
                this.hover = o;
                this.getNavigatorPanel().setCursor(this.hoverCursor);
                this.getNavigatorPanel().repaint(10L);
            }
        } else if (this.hover != null) {
            this.hover = null;
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hover != null) {
            this.hover = null;
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void turnedOff() {
        if (this.hover != null) {
            this.hover = null;
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    protected void turnedOn() {
    }

    public void setBucketsModel(GeoObjectBucketsModel<S, T> bucketsModel) {
        if (this.hover != null) {
            this.hover = null;
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
        this.bucketsModel = bucketsModel;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getName() {
        return "ObjectSelectorNavigatorRenderer";
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setRendererChecker(RendererChecker<S> rendererChecker) {
        this.rendererChecker = rendererChecker;
    }

    protected GeoObjectBucketsModel<S, T> getBucketsModel() {
        return this.bucketsModel;
    }
}

