/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.ValueChangeObservable;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.AbstractMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class ObjectMarkerNavigatorRenderer<S extends ValueChangeObservable, T extends ImmutableGeoObject>
extends AbstractMarkerNavigatorRenderer {
    private static final long serialVersionUID = 7368703372694682198L;
    public static final Color MARK_COLOR = new Color(255, 127, 127, 255);
    private static final Color HOVERCOLOR = new Color(127, 255, 127, 127);
    private GeoObjectBucketsModel<S, T> bucketsModel;
    protected Collection<S> markedObjects;
    private Collection<S> hoverSet;
    private S hover;
    private Collection<S> clickedSet;
    private Cursor hoverCursor;
    private AbstractNavigatorRenderer objectRenderer;
    private boolean showAllModels;
    private RendererChecker<S> rendererChecker;

    public ObjectMarkerNavigatorRenderer(String name, NavigatorPanel navigatorPanel, AbstractNavigatorRenderer objectRenderer, Double maxUpp, String title, GeoObjectBucketsModel<S, T> bucketsModel, Collection<S> markedObjects) {
        this(name, navigatorPanel, objectRenderer, maxUpp, title, bucketsModel, markedObjects, false);
    }

    public ObjectMarkerNavigatorRenderer(String name, NavigatorPanel navigatorPanel, AbstractNavigatorRenderer objectRenderer, Double maxUpp, String title, GeoObjectBucketsModel<S, T> bucketsModel, Collection<S> markedObjects, boolean showAllModels) {
        super(name, navigatorPanel, maxUpp, title);
        this.bucketsModel = bucketsModel;
        this.markedObjects = markedObjects;
        if (this.markedObjects == null) {
            this.markedObjects = new HashSet<S>();
        }
        this.hoverSet = new HashSet<S>();
        this.clickedSet = new ArrayList<S>();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/cross.png"));
        this.hoverCursor = toolkit.createCustomCursor(image, new Point(16, 16), "img");
        this.objectRenderer = objectRenderer;
        if (objectRenderer != null) {
            objectRenderer.setActive(false);
        }
        this.showAllModels = showAllModels;
    }

    public double getUppScale(double upp) {
        return Math.pow(upp, 0.3);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (!this.checkUpp()) {
            return Collections.emptyList();
        }
        int width = this.getNavigatorPanel().getWidth();
        int height = this.getNavigatorPanel().getHeight();
        if (height > 0 && width > 0) {
            Graphics2D g2da = g2d;
            Collection<S> objects = null;
            if (this.showAllModels) {
                CoordinateFactory factory = this.getNavigatorPanel().getCoordinateFactory();
                ImmutablePoint bottomLeft = ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(realBoundaryBottomLeft));
                ImmutablePoint topRight = ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(realBoundaryTopRight));
                objects = this.getFilteredObjects(this.bucketsModel.findObjects(bottomLeft, topRight));
                this.paintFirst(objects, upp, g2da);
                this.paintOnto(upp, g2da, objects);
            }
            for (ValueChangeObservable model : this.markedObjects) {
                this.render(model, g2da, upp, this.getMarkColor());
            }
            if (this.showAllModels) {
                this.paintOnToAfterMarkDrawn(objects, upp, g2da);
            }
            for (ValueChangeObservable model : this.hoverSet) {
                this.render(model, g2da, upp, HOVERCOLOR);
            }
        }
        return super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
    }

    protected void paintOnToAfterMarkDrawn(Collection<S> objects, double upp, Graphics2D g2da) {
    }

    protected void paintFirst(Collection<S> objects, double upp, Graphics2D g2d) {
    }

    protected void paintOnto(double upp, Graphics2D g2da, Collection<S> objects) {
        for (ValueChangeObservable model : objects) {
            this.render(model, g2da, upp, Color.WHITE);
        }
    }

    protected Color getMarkColor() {
        return MARK_COLOR;
    }

    public void render(S model, Graphics2D g2d, double upp, Color color) {
        Object geom = this.bucketsModel.extractGeom(model);
        if (geom != null) {
            if ((geom = geom.getTransformed(this.getNavigatorPanel().getCoordinateFactory())) instanceof ImmutablePoint) {
                this.drawPoint(g2d, (ImmutablePoint)geom, upp, color);
            } else if (geom instanceof ImmutableLineString) {
                this.drawLineString(g2d, (ImmutableLineString)geom, upp, color);
            } else if (geom instanceof ImmutablePolygon) {
                this.drawPolygon(g2d, (ImmutablePolygon)geom, upp, color);
            } else if (geom instanceof ImmutableMultiPolygon) {
                this.drawMultiPolygon(g2d, (ImmutableMultiPolygon)geom, upp, color);
            } else {
                throw new IllegalArgumentException("Not supported geoObject: " + geom);
            }
        }
    }

    protected void drawMultiPolygon(Graphics2D g2d, ImmutableMultiPolygon geom, double upp, Color color) {
        for (ImmutablePolygon immutablePolygon : geom.getParts()) {
            this.drawPolygon(g2d, immutablePolygon, upp, color);
        }
    }

    protected void drawPolygon(Graphics2D g2d, ImmutablePolygon geom, double upp, Color color) {
        g2d.setColor(color);
        g2d.fill(PaintUtil.createPolygonArea(geom));
    }

    protected void drawLineString(Graphics2D g2d, ImmutableLineString geom, double upp, Color color) {
        double margin = 15.0 * this.getUppScale(upp);
        boolean first = true;
        g2d.setColor(color);
        BasicStroke stroke = new BasicStroke((float)margin, 1, 1);
        g2d.setStroke(stroke);
        List<ImmutablePoint> coordinates = geom.getCoordinates();
        GeneralPath line = new GeneralPath(0, coordinates.size());
        for (ImmutablePoint immutablePoint : coordinates) {
            Coordinate c = immutablePoint.getCoordinate();
            if (first) {
                line.moveTo(c.getX(), c.getY());
                first = false;
                continue;
            }
            line.lineTo(c.getX(), c.getY());
        }
        g2d.draw(line);
    }

    protected void drawPoint(Graphics2D g2d, ImmutablePoint geom, double upp, Color color) {
        g2d.setColor(color);
        double margin = 5.0 * this.getUppScale(upp);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        Coordinate c = geom.getCoordinate();
        ellipse.x = c.getX() - margin;
        ellipse.y = c.getY() - margin;
        ellipse.width = 2.0 * margin;
        ellipse.height = 2.0 * margin;
        g2d.fill(ellipse);
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        Coordinate mouseNow = this.createCoordinateForPixel(x, y);
        Collection<Tupel<S, Double>> objects = this.bucketsModel.findObjectsWithDist(mouseNow, this.getClickedRadius() * this.getNavigatorPanel().getUpp());
        Collection<Tupel<S, Double>> marked = this.getFilteredObjectsWithDist(objects);
        if (!marked.isEmpty()) {
            if (clickCount == 1) {
                LinkedList<S> list = new LinkedList<S>();
                Iterator<Tupel<S, Double>> iter = marked.iterator();
                Tupel<S, Double> next = iter.next();
                list.add(next.getElement1());
                Double min = next.getElement2();
                while (iter.hasNext()) {
                    next = iter.next();
                    if (min.doubleValue() != next.getElement2().doubleValue()) break;
                    list.add(next.getElement1());
                }
                if (!this.markedObjects.addAll(list)) {
                    this.markedObjects.removeAll(list);
                }
            } else if (clickCount == 2) {
                ArrayList<S> list = new ArrayList<S>(marked.size());
                for (Tupel<S, Double> tupel : marked) {
                    list.add(tupel.getElement1());
                }
                this.clickedSet = new LinkedHashSet<S>(list);
            }
        }
        this.getNavigatorPanel().repaint(10L);
        super.mouseClicked(x, y, clickCount, modifiers, mouseButton);
        this.markedObjectsChanged();
    }

    protected double getClickedRadius() {
        return 50.0;
    }

    protected void markedObjectsChanged() {
    }

    @Override
    protected void mouseDragFinished(int x, int y, Coordinate startMark, Coordinate endMark, List<Coordinate> tracePoints, MarkerMode markerMode, int modifiers) {
        if (startMark != null && endMark != null) {
            Collection<S> marked = this.getFilteredObjects(this.bucketsModel.findObjects(startMark, endMark, tracePoints, markerMode));
            boolean changed = false;
            if ((modifiers & 0x40) == 64) {
                for (ValueChangeObservable o : marked) {
                    this.markedObjects.remove(o);
                    changed = true;
                }
            } else {
                for (ValueChangeObservable o : marked) {
                    this.markedObjects.add(o);
                    changed = true;
                }
            }
            if (changed) {
                this.markedObjectsChanged();
            }
        }
    }

    @Override
    protected void mouseDragged(int x, int y, Coordinate startMark, Coordinate endMark, List<Coordinate> tracePoints, MarkerMode markerMode, int modifiers) {
        Collection<S> marked = this.getFilteredObjects(this.bucketsModel.findObjects(startMark, endMark, tracePoints, markerMode));
        this.hoverSet.clear();
        Iterator<S> iterator = marked.iterator();
        while (iterator.hasNext()) {
            ValueChangeObservable o;
            if ((modifiers & 0x40) == 64 != this.markedObjects.contains(o = (ValueChangeObservable)iterator.next())) continue;
            this.hoverSet.add(o);
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected void mouseMoved(int x, int y) {
        Coordinate mouseNow = this.createCoordinateForPixel(x, y);
        Collection<S> underMouse = this.getFilteredObjects(this.bucketsModel.findObjects(mouseNow, 5.0 * this.getNavigatorPanel().getUpp()));
        if (this.isActive()) {
            if (!underMouse.isEmpty()) {
                this.hover = (ValueChangeObservable)underMouse.iterator().next();
                if (this.hoverSet.size() != 1 || !this.hoverSet.contains(this.hover)) {
                    this.hoverSet.clear();
                    this.hoverSet.add(this.hover);
                    this.getNavigatorPanel().setCursor(this.hoverCursor);
                    this.getNavigatorPanel().repaint(10L);
                }
            } else {
                this.hover = null;
                if (this.hoverSet.size() > 0) {
                    this.hoverSet.clear();
                    this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
                    this.getNavigatorPanel().repaint(10L);
                }
            }
        }
    }

    @Override
    protected void turnedOff() {
        if (this.hoverSet.size() > 0) {
            this.hoverSet.clear();
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
        super.turnedOff();
        if (this.objectRenderer != null) {
            this.objectRenderer.setActive(false);
        }
    }

    @Override
    protected void turnedOn() {
        super.turnedOn();
        if (this.objectRenderer != null) {
            this.objectRenderer.setActive(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hoverSet.size() > 0) {
            this.hoverSet.clear();
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    public Collection<S> getMarkedObjects() {
        if (this.markedObjects == null) {
            return new HashSet();
        }
        return new HashSet<S>(this.markedObjects);
    }

    public void initializeMarkedObjects(Set<S> markedObjects) {
        this.markedObjects = markedObjects;
    }

    public void setMarkedObjects(Collection<S> markedObjects) {
        if (this.markedObjects == null) {
            this.markedObjects = new HashSet<S>();
        }
        this.addMarkedObjects(markedObjects, true);
    }

    public void addMarkedObjects(Collection<S> markedObjects, boolean clear) {
        if (clear) {
            this.markedObjects.clear();
        }
        this.markedObjects.addAll(markedObjects);
        this.getNavigatorPanel().repaint(10L);
    }

    public void removeMarkedObjects(Collection<S> toRemoveObjects) {
        this.markedObjects.removeAll(toRemoveObjects);
        this.getNavigatorPanel().repaint(10L);
    }

    public void clearMarked() {
        this.markedObjects.clear();
        this.getNavigatorPanel().repaint(10L);
    }

    public GeoObjectBucketsModel<S, T> getBucketsModel() {
        return this.bucketsModel;
    }

    protected void setBucketsModel(GeoObjectBucketsModel<S, T> bucketsModel) {
        this.bucketsModel = bucketsModel;
    }

    protected Collection<S> getClickedSet() {
        return this.clickedSet;
    }

    protected S getHover() {
        return this.hover;
    }

    @Override
    public void close() {
        this.bucketsModel.clear();
    }

    public void setRendererChecker(RendererChecker<S> rendererChecker) {
        this.rendererChecker = rendererChecker;
    }

    protected Collection<Tupel<S, Double>> getFilteredObjectsWithDist(Collection<Tupel<S, Double>> ss) {
        if (this.rendererChecker == null) {
            return ss;
        }
        LinkedList<Tupel<S, Double>> list = new LinkedList<Tupel<S, Double>>();
        for (Tupel<S, Double> s : ss) {
            if (!this.rendererChecker.isToBeRendered(s.getElement1())) continue;
            list.add(s);
        }
        return list;
    }

    protected Collection<S> getFilteredObjects(Collection<S> ss) {
        if (this.rendererChecker == null) {
            return ss;
        }
        LinkedList<ValueChangeObservable> list = new LinkedList<ValueChangeObservable>();
        for (ValueChangeObservable s : ss) {
            if (!this.rendererChecker.isToBeRendered(s)) continue;
            list.add(s);
        }
        return list;
    }
}

