/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.swing.ArrowStroke;
import de.datomino.util.geo.swing.DefaultImmutableGeoObjectNavigatorRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.ExplodableNavigatorListener;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class ExplodableImmutableGeoObjectNavigatorRenderer
extends DefaultImmutableGeoObjectNavigatorRenderer
implements ExplodableNavigatorListener {
    private static final Tupel<Color, Color> SHADOWCOLOR = new Tupel<Color, Color>(Color.GRAY, Color.GRAY);
    private int explodeLevel = 0;
    private int offsetPoints = 0;
    private int offsetLinestrings = 0;
    private ThreadLocal<Integer> renderPass = new ThreadLocal();
    private ThreadLocal<Map<GeomAccess<?>, GeomAccess<?>>> origGeomMap = new ThreadLocal();
    private Map<GeomAccess<?>, Integer> levelMap = new IdentityHashMap();
    private Map<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>> usedPointLevelPoly = new HashMap<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>>();
    private Map<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>> usedPointLevelLine = new HashMap<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>>();
    private Map<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>> usedPointLevelPoint = new HashMap<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>>();

    public ExplodableImmutableGeoObjectNavigatorRenderer() {
        super("ExplodableImmutableGeoObjectNavigatorRenderer");
    }

    @Override
    public void setExplodeLevel(int level) {
        this.explodeLevel = level;
        this.callRepaint();
    }

    private ImmutableGeoObject translate(GeomAccess<? extends ImmutableGeoObject> geom, double upp, double offset) {
        int base = this.levelMap.get(geom);
        double shift = ((double)base + offset) * (double)this.explodeLevel;
        ImmutableGeoObject geomO = geom.getGeom();
        double pixel = upp * shift;
        double ref1 = this.getPanel().getCoordinateFactory().getRefScale();
        double ref2 = geomO.getCoordinateFactory().getRefScale();
        pixel = pixel * ref1 / ref2;
        ImmutableGeoObject geomO2 = geomO.getTranslated(pixel, pixel);
        return geomO2;
    }

    @Override
    protected void callRender(Graphics2D g2d, double upp, CoordinateFactory factory, GeomAccess<? extends ImmutableGeoObject> geom) {
        if (this.renderPass.get() < 1) {
            super.callRender(g2d, upp, factory, geom);
        } else {
            ImmutableGeoObject object = geom.getGeom();
            double offset = 0.0;
            if (object instanceof ImmutablePoint) {
                offset = this.offsetPoints;
            } else if (object instanceof ImmutableLineString) {
                offset = this.offsetLinestrings;
            } else if (object instanceof ImmutableMultiLineString) {
                offset = this.offsetLinestrings;
            }
            GeomAccess translatedgeom = (GeomAccess)((Object)this.translate(geom, upp, offset));
            this.origGeomMap.get().put(translatedgeom, geom);
            super.callRender(g2d, upp, factory, translatedgeom);
        }
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.explodeLevel == 0) {
            this.renderPass.set(-1);
            try {
                return super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
            }
            catch (RuntimeException re) {
                return Collections.emptyList();
            }
        }
        this.origGeomMap.set(new IdentityHashMap());
        this.renderPass.set(0);
        LinkedList<OnTopRendering> onTops = new LinkedList<OnTopRendering>(super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp));
        this.renderPass.set(1);
        onTops.addAll(super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp));
        this.origGeomMap.remove();
        this.renderPass.remove();
        return onTops;
    }

    @Override
    protected Tupel<Color, Color> getColor(GeomAccess<? extends ImmutableGeoObject> geom) {
        switch (this.renderPass.get()) {
            case -1: {
                return super.getColor(geom);
            }
            case 0: {
                return SHADOWCOLOR;
            }
            case 1: {
                return super.getColor((GeomAccess<? extends ImmutableGeoObject>)this.origGeomMap.get().get(geom));
            }
        }
        return null;
    }

    @Override
    public void add(GeomAccess<? extends ImmutableGeoObject> e, int color) {
        this.findGeomLevel(e);
        super.add(e, color);
    }

    private void findGeomLevel(GeomAccess<? extends ImmutableGeoObject> geomAccess) {
        ImmutableGeoObject geom = geomAccess.getGeom();
        if (geom instanceof ImmutablePoint) {
            this.findGeomLevel(geomAccess, this.usedPointLevelPoint, 0);
        } else if (geom instanceof ImmutableLineString) {
            this.findGeomLevel(geomAccess, this.usedPointLevelLine, 1);
        } else if (geom instanceof ImmutableMultiLineString) {
            this.findGeomLevel(geomAccess, this.usedPointLevelLine, 1);
        } else if (geom instanceof ImmutablePolygon) {
            this.findGeomLevel(geomAccess, this.usedPointLevelPoly, 2);
        } else if (geom instanceof ImmutableMultiPolygon) {
            this.findGeomLevel(geomAccess, this.usedPointLevelPoly, 2);
        }
    }

    private void findGeomLevel(GeomAccess<? extends ImmutableGeoObject> geomAccess, Map<Integer, Set<GeomAccess<? extends ImmutableGeoObject>>> usedLevels, int mode) {
        boolean free = false;
        int l = 1;
        while (!free) {
            Set<GeomAccess<? extends ImmutableGeoObject>> objects = usedLevels.get(l);
            if (objects == null) {
                objects = new HashSet<GeomAccess<? extends ImmutableGeoObject>>();
                usedLevels.put(l, objects);
            } else {
                for (GeomAccess<? extends ImmutableGeoObject> othergeom : objects) {
                    if (!this.intersects(geomAccess.getGeom(), othergeom.getGeom())) continue;
                    ++l;
                }
            }
            objects.add(geomAccess);
            this.levelMap.put(geomAccess, l);
            free = true;
        }
        if (mode == 2) {
            if (l >= this.offsetLinestrings) {
                this.offsetPoints -= this.offsetLinestrings;
                this.offsetLinestrings = l + 1;
                this.offsetPoints += this.offsetLinestrings;
            }
        } else if (mode == 1 && this.offsetLinestrings + l >= this.offsetPoints) {
            this.offsetPoints = this.offsetLinestrings + l + 1;
        }
    }

    private boolean intersects(ImmutableGeoObject geom, ImmutableGeoObject othergeom) {
        try {
            if (geom instanceof ImmutablePoint) {
                return geom.equals(othergeom);
            }
            if (geom instanceof ImmutableLineString) {
                return geom.intersects(othergeom) && !geom.touches(othergeom);
            }
            if (geom instanceof ImmutableMultiLineString) {
                return geom.intersects(othergeom) && !geom.touches(othergeom);
            }
            if (geom instanceof ImmutablePolygon) {
                return othergeom.intersects(geom) && !geom.touches(othergeom);
            }
            if (geom instanceof ImmutableMultiPolygon) {
                return othergeom.intersects(geom) && !geom.touches(othergeom);
            }
        }
        catch (RuntimeException re) {
            return true;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.levelMap.clear();
        this.offsetPoints = 0;
        this.offsetLinestrings = 0;
        this.usedPointLevelPoly.clear();
        this.usedPointLevelLine.clear();
        this.usedPointLevelPoint.clear();
    }

    @Override
    protected Stroke getLinestringStroke(double margin) {
        return new ArrowStroke((float)margin);
    }
}

