/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;

public class ClickedPolygonMarkerNavigatorRenderer {
    private List<Coordinate> marks;
    private boolean clickMode = false;
    private Coordinate currentCursor;

    void paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp, float widthFactor) {
        if (this.clickMode && this.marks != null && !this.marks.isEmpty()) {
            ArrayList<Coordinate> markLine = new ArrayList<Coordinate>(this.marks.size() + 1);
            markLine.addAll(this.marks);
            if (this.currentCursor != null) {
                markLine.add(this.currentCursor);
            }
            try {
                ImmutableLineString markLineString = ImmutableGeoObjectFactory.createImmutableLineString(markLine);
                this.drawMarkLine(g2d, markLineString, upp, widthFactor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void drawMarkLine(Graphics2D g2d, ImmutableLineString markLineString, double upp, float widthFactor) {
        Path2D path = PaintUtil.createPath2D(markLineString);
        BasicStroke stroke = new BasicStroke((float)(upp * (double)widthFactor));
        g2d.setStroke(stroke);
        g2d.draw(path);
    }

    Collection<ImmutablePolygonKind> mouseClicked(Coordinate coord, int clickCount, int modifiers, MouseButton mouseButton, NavigatorPanel navigatorPanel) {
        if (mouseButton == MouseButton.BUTTON1) {
            if (!this.clickMode) {
                this.clickMode = true;
                this.marks = new LinkedList<Coordinate>();
            }
            this.marks.add(coord);
        } else if (mouseButton == MouseButton.BUTTON2 && this.marks != null) {
            this.marks.add(coord);
            ImmutablePolygonKind poly = null;
            if (this.marks.size() > 2) {
                GeoUtils.SearchPolygon searchPolygon = GeoUtils.createSearchPolygon(this.marks.get(0), this.marks.get(this.marks.size() - 1), MarkerMode.FREEHAND_HALF, this.marks.subList(0, this.marks.size()), navigatorPanel.getCoordinateFactory(), true);
                poly = searchPolygon.getPolygon();
            }
            this.clickMode = false;
            this.marks = null;
            List emptyList = Collections.emptyList();
            return poly == null ? emptyList : Collections.singleton(poly);
        }
        return Collections.emptyList();
    }

    void mouseMoved(Coordinate coordinate) {
        if (this.clickMode) {
            this.currentCursor = coordinate;
        }
    }
}

