/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;

public class ArrowStroke
implements Stroke {
    private BasicStroke delegate;
    private BasicStroke delegate2;
    private double margin;

    public ArrowStroke(float margin) {
        this.delegate = new BasicStroke(margin);
        this.delegate2 = new BasicStroke(margin / 2.0f);
        this.margin = margin;
    }

    @Override
    public Shape createStrokedShape(Shape p) {
        Shape strokeShape = this.delegate.createStrokedShape(p);
        if (p instanceof Line2D) {
            Line2D line = (Line2D)p;
            double x2 = line.getX2();
            double y2 = line.getY2();
            double angle = Math.atan2(y2 - line.getY1(), x2 - line.getX1());
            double w = 0.39269908169872414;
            double l = 5.0 * this.margin;
            double angleA = (angle + Math.PI * 2 - w) % (Math.PI * 2) - Math.PI;
            double angleB = (angle + Math.PI * 2 + w) % (Math.PI * 2) - Math.PI;
            Line2D.Double lineA = new Line2D.Double(x2, y2, x2 + Math.cos(angleA) * l, y2 + Math.sin(angleA) * l);
            Line2D.Double lineB = new Line2D.Double(x2, y2, x2 + Math.cos(angleB) * l, y2 + Math.sin(angleB) * l);
            Shape sA = this.delegate2.createStrokedShape(lineA);
            Shape sB = this.delegate2.createStrokedShape(lineB);
            strokeShape = new Area(strokeShape);
            ((Area)strokeShape).add(new Area(sA));
            ((Area)strokeShape).add(new Area(sB));
        }
        return strokeShape;
    }
}

