/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import java.awt.event.MouseWheelEvent;
import javax.swing.Icon;
import org.ktde.swing.UndoManager;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;

public abstract class AbstractRollbackingMouseManipulatorAction
extends AbstractEnhancedMouseManipulatorAction {
    private static final long serialVersionUID = -3595963787303789552L;
    protected final UndoManager undoManager;

    protected abstract String performMouseClicked(int var1, int var2, int var3);

    protected abstract void performMouseDragged(int var1, int var2);

    protected abstract String performMouseDragFinished(int var1, int var2);

    protected abstract void performMousePressed(int var1, int var2);

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, Icon icon, boolean on) {
        super(navigatorPanel, maxUpp, icon, on);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, Icon iconOn, Icon iconOff, boolean on) {
        super(navigatorPanel, maxUpp, iconOn, iconOff, on);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, Icon iconOn, Icon iconOff) {
        super(navigatorPanel, maxUpp, iconOn, iconOff);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, Icon icon) {
        super(navigatorPanel, maxUpp, icon);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String title, boolean on) {
        super(navigatorPanel, maxUpp, title, on);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String title, Icon icon, boolean on) {
        super(navigatorPanel, maxUpp, title, icon, on);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String title, Icon icon) {
        super(navigatorPanel, maxUpp, title, icon);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String titleOn, String titleOff, boolean on) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, on);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String titleOn, String titleOff, Icon iconOn, Icon iconOff, boolean on) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, iconOn, iconOff, on);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String titleOn, String titleOff, Icon iconOn, Icon iconOff) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, iconOn, iconOff);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String titleOn, String titleOff) {
        super(navigatorPanel, maxUpp, titleOn, titleOff);
        this.undoManager = undoManager;
    }

    public AbstractRollbackingMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, UndoManager undoManager, String title) {
        super(navigatorPanel, maxUpp, title);
        this.undoManager = undoManager;
    }

    @Override
    protected final void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        try {
            this.undoManager.joinTransaction();
            this.undoManager.finishTransaction(this.performMouseClicked(x, y, clickCount));
        }
        catch (RuntimeException re) {
            this.handleException(re);
        }
    }

    @Override
    protected final void mouseDragFinished(int x, int y, int modifiers) {
        try {
            this.undoManager.joinTransaction();
            this.undoManager.finishTransaction(this.performMouseDragFinished(x, y));
        }
        catch (RuntimeException re) {
            this.handleException(re);
        }
    }

    @Override
    protected final void mouseDragged(int x, int y) {
        try {
            this.undoManager.joinTransaction();
            this.performMouseDragged(x, y);
        }
        catch (RuntimeException re) {
            this.handleException(re);
        }
    }

    @Override
    protected final void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
        this.undoManager.startTransaction();
        try {
            this.performMousePressed(x, y);
        }
        catch (RuntimeException re) {
            this.handleException(re);
        }
    }

    protected void handleException(RuntimeException re) {
        this.undoManager.rollbackTransaction();
        this.showException(re);
    }

    protected abstract void showException(RuntimeException var1);

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }
}

