/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.swing.AbstractGeometryNavigatorRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.ktde.util.datatypes.Tripel;

public abstract class AbstractGeometryNavigatorStaticRenderer<S, T extends ImmutableGeoObject>
extends AbstractGeometryNavigatorRenderer<S, T> {
    private LineRenderer<?, S> lineRenderer;
    private AreaRenderer<?, S> areaRenderer;
    private PointRenderer<?, S> pointRenderer;

    public AbstractGeometryNavigatorStaticRenderer(String name, AreaRenderer<?, S> areaRenderer, LineRenderer<?, S> lineRenderer, PointRenderer<?, S> pointRenderer, GeomExtractor<S, T> geomExtractor) {
        this(name, 0.0, 50.0, areaRenderer, lineRenderer, pointRenderer, geomExtractor);
    }

    public AbstractGeometryNavigatorStaticRenderer(String name, double minUpp, double maxUpp, AreaRenderer<?, S> areaRenderer, LineRenderer<?, S> lineRenderer, PointRenderer<?, S> pointRenderer, GeomExtractor<S, T> geomExtractor) {
        super(name, minUpp, maxUpp, geomExtractor);
        this.lineRenderer = lineRenderer;
        this.areaRenderer = areaRenderer;
        this.pointRenderer = pointRenderer;
    }

    @Override
    protected <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> getRenderersForModel(S model, int cycle) {
        AreaRenderer<?, S> lAreaRenderer = this.areaRenderer;
        LineRenderer<?, S> lLineRenderer = this.lineRenderer;
        PointRenderer<?, S> lPointRenderer = this.pointRenderer;
        Tripel tripel = new Tripel(lAreaRenderer, lLineRenderer, lPointRenderer);
        Set<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> collection = Collections.singleton(tripel);
        return collection;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LineRenderer lineRendererClone;
        AreaRenderer areaRendererClone;
        AbstractGeometryNavigatorStaticRenderer clone = (AbstractGeometryNavigatorStaticRenderer)super.clone();
        clone.areaRenderer = areaRendererClone = (AreaRenderer)this.areaRenderer.clone();
        clone.lineRenderer = lineRendererClone = (LineRenderer)this.lineRenderer.clone();
        return clone;
    }

    protected LineRenderer<?, S> getLineRenderer() {
        return this.lineRenderer;
    }

    protected PointRenderer<?, S> getPointRenderer() {
        return this.pointRenderer;
    }
}

